/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.test.executor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.fluentcommerce.util.dynamic.graphql.DynamicEntityQuery;
import com.fluentcommerce.util.test.TestUtils;
import com.fluentcommerce.util.test.executor.MockApiClient;
import com.fluentcommerce.util.test.executor.RuleContextGenerator;
import com.fluentcommerce.util.test.executor.RuleRepository;
import com.fluentretail.api.v2.client.ReadOnlyFluentApiClient;
import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.workflow.RuleInstance;
import com.fluentretail.rubix.workflow.Workflow;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class WorkflowExecutor {
    private final MockApiClient apiMock;
    private final ReadOnlyFluentApiClient api;
    private final Workflow workflow;
    private final Map<String, Consumer<RuleContextGenerator.RuleTestContext>> ruleMocks = new HashMap<String, Consumer<RuleContextGenerator.RuleTestContext>>();
    private final Map<String, MockApiClient> apiMocks = new HashMap<String, MockApiClient>();
    private static final int NUMBER_OF_RULE_NAME_PATH = 3;

    public WorkflowExecutor(Workflow workflow) {
        this.apiMock = new MockApiClient();
        this.api = this.apiMock.get();
        this.workflow = workflow;
    }

    public WorkflowExecutor mockRule(String name, Consumer<RuleContextGenerator.RuleTestContext> rule) {
        this.ruleMocks.put(name, rule);
        return this;
    }

    public WorkflowExecutor withLegacyClient(String ruleName, com.fluentretail.api.client.ReadOnlyFluentApiClient legacyExecutor) {
        MockApiClient apiClient = this.getApiMock(ruleName);
        apiClient.withLegacyClient(legacyExecutor);
        return this;
    }

    public WorkflowExecutor ignoreRules(String ... names) {
        for (String name : names) {
            this.ruleMocks.put(name, t -> {});
        }
        return this;
    }

    private RuleRepository.ExecutableRule getRule(RuleInstance ruleInstance) {
        String[] rulePaths = ruleInstance.getName().split("\\.");
        if (rulePaths.length < 3) {
            return this.ruleMocks.containsKey(ruleInstance.getName()) ? RuleRepository.MockExecutableRule.of(this.ruleMocks.get(ruleInstance.getName())) : RuleRepository.get(ruleInstance.getName());
        }
        rulePaths = new String[]{rulePaths[rulePaths.length - 2], rulePaths[rulePaths.length - 1]};
        if (this.ruleMocks.containsKey(ruleInstance.getName())) {
            return RuleRepository.MockExecutableRule.of(this.ruleMocks.get(ruleInstance.getName()));
        }
        String ruleName = rulePaths[0] + rulePaths[1];
        if (this.ruleMocks.containsKey(ruleName)) {
            return RuleRepository.MockExecutableRule.of(this.ruleMocks.get(ruleName));
        }
        ruleName = rulePaths[1];
        if (this.ruleMocks.containsKey(ruleName)) {
            return RuleRepository.MockExecutableRule.of(this.ruleMocks.get(ruleName));
        }
        return RuleRepository.get(ruleName);
    }

    public RuleContextGenerator execute() {
        return this.execute(Event.builder().build());
    }

    public RuleContextGenerator execute(Event eventOverrides) {
        Event event = TestUtils.eventWithDefaults(eventOverrides);
        RuleContextGenerator context = RuleContextGenerator.of(event, this.api);
        do {
            Event thisEvent = context.getEvent();
            this.workflow.getRulesets().stream().filter(rs -> rs.matches(thisEvent)).forEach(rs -> rs.getRules().forEach(rule -> {
                RuleRepository.ExecutableRule thisRule = this.getRule((RuleInstance)rule);
                thisRule.run(context.mockApiClient(this.getApiMock(rule.getName())).forRule((RuleInstance)rule));
                TestUtils.validateEventAgainstProduces(thisRule, context, rule);
            }));
        } while (context.nextEvent());
        return context;
    }

    public static WorkflowExecutor of(Workflow workflow) {
        return new WorkflowExecutor(workflow);
    }

    public static WorkflowExecutor of(String workflowFile) {
        return new WorkflowExecutor(TestUtils.loadWorkflowFromFile(workflowFile));
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> WorkflowExecutor mockNamedQuery(String ruleName, Class<Q> query, String file, String ... moreFiles) {
        this.apiMocks.put(ruleName, this.apiMocks.getOrDefault(ruleName, new MockApiClient()).mockNamedQuery(query, file, moreFiles));
        return this;
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> WorkflowExecutor mockNamedQuery(String ruleName, Class<Q> query, D data, D ... moreData) {
        this.apiMocks.put(ruleName, this.apiMocks.getOrDefault(ruleName, new MockApiClient()).mockNamedQuery(query, data, (Operation.Data[])moreData));
        return this;
    }

    public WorkflowExecutor mockDynamic(String ruleName, String file) {
        this.apiMocks.put(ruleName, new MockApiClient().mockNamedQuery(DynamicEntityQuery.class, file, new String[0]));
        return this;
    }

    public MockApiClient getApiMock() {
        return this.apiMock;
    }

    private MockApiClient getApiMock(String ruleName) {
        return this.apiMocks.getOrDefault(ruleName, this.apiMock);
    }
}

