/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.test.executor;

import com.apollographql.apollo.api.Mutation;
import com.fluentcommerce.util.test.ApolloUtils;
import com.fluentcommerce.util.test.executor.RuleContextGenerator;
import com.fluentretail.api.model.attribute.Attribute;
import com.fluentretail.rubix.action.Action;
import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.v2.action.ActionFactory;
import com.fluentretail.rubix.workflow.ServiceManager;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class TestActions {

    public static final class WebhookAction
    extends BaseAction {
        private final String webhookEndpoint;
        private final Event event;

        public static WebhookAction get(String webhookEndpoint, Event event) {
            return new WebhookAction(webhookEndpoint, event);
        }

        @Generated
        public String getWebhookEndpoint() {
            return this.webhookEndpoint;
        }

        @Generated
        public Event getEvent() {
            return this.event;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WebhookAction)) {
                return false;
            }
            WebhookAction other = (WebhookAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$webhookEndpoint = this.getWebhookEndpoint();
            String other$webhookEndpoint = other.getWebhookEndpoint();
            if (this$webhookEndpoint == null ? other$webhookEndpoint != null : !this$webhookEndpoint.equals(other$webhookEndpoint)) {
                return false;
            }
            Event this$event = this.getEvent();
            Event other$event = other.getEvent();
            return !(this$event == null ? other$event != null : !this$event.equals(other$event));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WebhookAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $webhookEndpoint = this.getWebhookEndpoint();
            result = result * 59 + ($webhookEndpoint == null ? 43 : $webhookEndpoint.hashCode());
            Event $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : $event.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TestActions.WebhookAction(webhookEndpoint=" + this.getWebhookEndpoint() + ", event=" + this.getEvent() + ")";
        }

        @ConstructorProperties(value={"webhookEndpoint", "event"})
        @Generated
        public WebhookAction(String webhookEndpoint, Event event) {
            this.webhookEndpoint = webhookEndpoint;
            this.event = event;
        }
    }

    public static final class LogAction
    extends BaseAction {
        private final Event sourceEvent;
        private final String message;
        private final String detailedMessage;
        private final List<Attribute> attributes;

        @Generated
        public Event getSourceEvent() {
            return this.sourceEvent;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getDetailedMessage() {
            return this.detailedMessage;
        }

        @Generated
        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogAction)) {
                return false;
            }
            LogAction other = (LogAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Event this$sourceEvent = this.getSourceEvent();
            Event other$sourceEvent = other.getSourceEvent();
            if (this$sourceEvent == null ? other$sourceEvent != null : !this$sourceEvent.equals(other$sourceEvent)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$detailedMessage = this.getDetailedMessage();
            String other$detailedMessage = other.getDetailedMessage();
            if (this$detailedMessage == null ? other$detailedMessage != null : !this$detailedMessage.equals(other$detailedMessage)) {
                return false;
            }
            List<Attribute> this$attributes = this.getAttributes();
            List<Attribute> other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LogAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Event $sourceEvent = this.getSourceEvent();
            result = result * 59 + ($sourceEvent == null ? 43 : $sourceEvent.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $detailedMessage = this.getDetailedMessage();
            result = result * 59 + ($detailedMessage == null ? 43 : $detailedMessage.hashCode());
            List<Attribute> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TestActions.LogAction(sourceEvent=" + this.getSourceEvent() + ", message=" + this.getMessage() + ", detailedMessage=" + this.getDetailedMessage() + ", attributes=" + this.getAttributes() + ")";
        }

        @ConstructorProperties(value={"sourceEvent", "message", "detailedMessage", "attributes"})
        @Generated
        public LogAction(Event sourceEvent, String message, String detailedMessage, List<Attribute> attributes) {
            this.sourceEvent = sourceEvent;
            this.message = message;
            this.detailedMessage = detailedMessage;
            this.attributes = attributes;
        }
    }

    public static final class SendEventAction
    extends BaseAction {
        private final Event event;

        public boolean isFutureDated() {
            return this.event.getScheduledOn() != null;
        }

        @Generated
        public Event getEvent() {
            return this.event;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendEventAction)) {
                return false;
            }
            SendEventAction other = (SendEventAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Event this$event = this.getEvent();
            Event other$event = other.getEvent();
            return !(this$event == null ? other$event != null : !this$event.equals(other$event));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SendEventAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Event $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : $event.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TestActions.SendEventAction(event=" + this.getEvent() + ")";
        }

        @ConstructorProperties(value={"event"})
        @Generated
        public SendEventAction(Event event) {
            this.event = event;
        }
    }

    public static final class MutateAction
    extends BaseAction {
        public final Mutation mutation;

        public <T> T getMutationInputAs(Class<T> inputType) {
            return ApolloUtils.getMutationVariable(this.mutation, "input", inputType);
        }

        @Generated
        public Mutation getMutation() {
            return this.mutation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MutateAction)) {
                return false;
            }
            MutateAction other = (MutateAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Mutation this$mutation = this.getMutation();
            Mutation other$mutation = other.getMutation();
            return !(this$mutation == null ? other$mutation != null : !this$mutation.equals(other$mutation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MutateAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Mutation $mutation = this.getMutation();
            result = result * 59 + ($mutation == null ? 43 : $mutation.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TestActions.MutateAction(mutation=" + this.getMutation() + ")";
        }

        @ConstructorProperties(value={"mutation"})
        @Generated
        public MutateAction(Mutation mutation) {
            this.mutation = mutation;
        }
    }

    private static class BaseAction
    implements Action {
        private BaseAction() {
        }

        public List<com.fluentretail.api.model.event.Event> fire(ServiceManager serviceManager) {
            System.out.println("Fired action: " + this.getClass());
            return new ArrayList<com.fluentretail.api.model.event.Event>();
        }
    }

    public static final class TestActionFactory
    implements ActionFactory {
        private final RuleContextGenerator.RuleTestContext.RuleContext ctx;

        public void mutation(Mutation mutation) {
            this.ctx.pushAction(new MutateAction(mutation));
        }

        public void mutation(Mutation mutation, String s) {
            this.mutation(mutation);
        }

        public void sendEvent(Event event) {
            this.ctx.pushEvent(event);
            this.ctx.pushAction(new SendEventAction(event));
        }

        public void log(String message, String detailedMessage, List<Attribute> attributes) {
            try {
                attributes.add(Attribute.of((String)"mutability_test", (String)"success"));
            }
            catch (Exception e) {
                throw new RuntimeException("Log event only supports a mutable list of attributes");
            }
            this.ctx.pushAction(new LogAction(this.ctx.getEvent(), message, detailedMessage, attributes));
        }

        public void postWebhook(String url, Event event) {
            this.ctx.pushAction(WebhookAction.get(url, event));
        }

        @ConstructorProperties(value={"ctx"})
        @Generated
        private TestActionFactory(RuleContextGenerator.RuleTestContext.RuleContext ctx) {
            this.ctx = ctx;
        }

        @Generated
        public static TestActionFactory of(RuleContextGenerator.RuleTestContext.RuleContext ctx) {
            return new TestActionFactory(ctx);
        }

        @Generated
        public RuleContextGenerator.RuleTestContext.RuleContext getCtx() {
            return this.ctx;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestActionFactory)) {
                return false;
            }
            TestActionFactory other = (TestActionFactory)o;
            RuleContextGenerator.RuleTestContext.RuleContext this$ctx = this.getCtx();
            RuleContextGenerator.RuleTestContext.RuleContext other$ctx = other.getCtx();
            return !(this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RuleContextGenerator.RuleTestContext.RuleContext $ctx = this.getCtx();
            result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TestActions.TestActionFactory(ctx=" + this.getCtx() + ")";
        }
    }
}

