/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.test.executor;

import com.fluentcommerce.util.test.TestUtils;
import com.fluentcommerce.util.test.executor.RuleContextGenerator;
import com.fluentretail.rubix.exceptions.RuleNotFoundException;
import com.fluentretail.rubix.rule.BaseRule;
import com.fluentretail.rubix.rule.meta.EventAttribute;
import com.fluentretail.rubix.rule.meta.ParamAttributeType;
import com.fluentretail.rubix.rule.meta.ParamEnum;
import com.fluentretail.rubix.rule.meta.ParamInteger;
import com.fluentretail.rubix.rule.meta.ParamString;
import com.fluentretail.rubix.rule.meta.ParamTimePeriod;
import com.fluentretail.rubix.rule.meta.RuleInfo;
import com.fluentretail.rubix.v2.context.Context;
import com.fluentretail.rubix.v2.rule.Rule;
import com.fluentretail.rubix.workflow.RuleInstance;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;

public class RuleRepository {
    static final Map<String, Rule> rules;

    private static <T extends BaseRule> T instantiateRule(Class<T> clazz) {
        try {
            return (T)((BaseRule)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            System.out.println("Failed to instantiate Rule class " + clazz);
            e.printStackTrace();
            return null;
        }
    }

    public static ExecutableRule get(RuleInstance inst) {
        return RuleRepository.get(inst.getName());
    }

    public static ExecutableRule get(String name) {
        String ruleName = TestUtils.getRuleName(name);
        Rule rule = rules.get(ruleName);
        if (rule != null) {
            return ExecutableRuleImpl.of(rule);
        }
        List v2rules = rules.values().stream().map(r -> r.getClass().getSimpleName()).collect(Collectors.toList());
        throw new RuleNotFoundException(name, v2rules);
    }

    static {
        try {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            TestUtils.gatherRules().forEach(c -> builder.put((Object)c.getAnnotation(RuleInfo.class).name(), RuleRepository.instantiateRule(c)));
            rules = builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Multiple rules have the same name! Check your @RuleInfo details.", e);
        }
        System.out.println("TestExecutor gathered rules: " + rules);
    }

    public static final class MockExecutableRule
    implements ExecutableRule {
        private final Consumer<RuleContextGenerator.RuleTestContext> mock;

        @Override
        public void run(RuleContextGenerator.RuleTestContext context) {
            this.mock.accept(context);
        }

        @Override
        public RuleInfo info() {
            return EmptyMockRule.class.getAnnotation(RuleInfo.class);
        }

        @Override
        public ImmutableMap<String, Annotation> params() {
            return ImmutableMap.of();
        }

        @Override
        public ImmutableMap<String, EventAttribute> attributes() {
            return ImmutableMap.of();
        }

        @ConstructorProperties(value={"mock"})
        @Generated
        private MockExecutableRule(Consumer<RuleContextGenerator.RuleTestContext> mock) {
            this.mock = mock;
        }

        @Generated
        public static MockExecutableRule of(Consumer<RuleContextGenerator.RuleTestContext> mock) {
            return new MockExecutableRule(mock);
        }

        @Generated
        public Consumer<RuleContextGenerator.RuleTestContext> getMock() {
            return this.mock;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MockExecutableRule)) {
                return false;
            }
            MockExecutableRule other = (MockExecutableRule)o;
            Consumer<RuleContextGenerator.RuleTestContext> this$mock = this.getMock();
            Consumer<RuleContextGenerator.RuleTestContext> other$mock = other.getMock();
            return !(this$mock == null ? other$mock != null : !this$mock.equals(other$mock));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<RuleContextGenerator.RuleTestContext> $mock = this.getMock();
            result = result * 59 + ($mock == null ? 43 : $mock.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RuleRepository.MockExecutableRule(mock=" + this.getMock() + ")";
        }
    }

    @RuleInfo(name="MockRule", description="A mock rule")
    public static class EmptyMockRule {
    }

    public static final class ExecutableRuleImpl
    implements ExecutableRule {
        private final Rule rule;

        @Override
        public void run(RuleContextGenerator.RuleTestContext context) {
            this.rule.run((Context)context.context());
        }

        @Override
        public RuleInfo info() {
            return this.rule.getClass().getAnnotation(RuleInfo.class);
        }

        @Override
        public ImmutableMap<String, Annotation> params() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ParamString paramString : (ParamString[])this.rule.getClass().getAnnotationsByType(ParamString.class)) {
                builder.put((Object)paramString.name(), (Object)paramString);
            }
            for (ParamString paramString : (ParamInteger[])this.rule.getClass().getAnnotationsByType(ParamInteger.class)) {
                builder.put((Object)paramString.name(), (Object)paramString);
            }
            for (ParamString paramString : (ParamEnum[])this.rule.getClass().getAnnotationsByType(ParamEnum.class)) {
                builder.put((Object)paramString.name(), (Object)paramString);
            }
            for (ParamString paramString : (ParamTimePeriod[])this.rule.getClass().getAnnotationsByType(ParamTimePeriod.class)) {
                builder.put((Object)paramString.name(), (Object)paramString);
            }
            for (ParamString paramString : (ParamAttributeType[])this.rule.getClass().getAnnotationsByType(ParamAttributeType.class)) {
                builder.put((Object)paramString.name(), (Object)paramString);
            }
            return builder.build();
        }

        @Override
        public ImmutableMap<String, EventAttribute> attributes() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (EventAttribute anno : (EventAttribute[])this.rule.getClass().getAnnotationsByType(EventAttribute.class)) {
                builder.put((Object)anno.name(), (Object)anno);
            }
            return builder.build();
        }

        @ConstructorProperties(value={"rule"})
        @Generated
        private ExecutableRuleImpl(Rule rule) {
            this.rule = rule;
        }

        @Generated
        public static ExecutableRuleImpl of(Rule rule) {
            return new ExecutableRuleImpl(rule);
        }

        @Generated
        public Rule getRule() {
            return this.rule;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecutableRuleImpl)) {
                return false;
            }
            ExecutableRuleImpl other = (ExecutableRuleImpl)o;
            Rule this$rule = this.getRule();
            Rule other$rule = other.getRule();
            return !(this$rule == null ? other$rule != null : !this$rule.equals(other$rule));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Rule $rule = this.getRule();
            result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RuleRepository.ExecutableRuleImpl(rule=" + this.getRule() + ")";
        }
    }

    public static interface ExecutableRule {
        public void run(RuleContextGenerator.RuleTestContext var1);

        public RuleInfo info();

        public ImmutableMap<String, Annotation> params();

        public ImmutableMap<String, EventAttribute> attributes();
    }
}

