/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.test.executor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.fluentcommerce.graphql.queries.introspection.IntrospectionQuery;
import com.fluentcommerce.util.dynamic.graphql.DynamicEntityQuery;
import com.fluentcommerce.util.dynamic.graphql.GraphQLIntrospectionUtils;
import com.fluentcommerce.util.test.TestUtils;
import com.fluentcommerce.util.test.executor.MockApiClient;
import com.fluentcommerce.util.test.executor.QueryMock;
import com.fluentcommerce.util.test.executor.RuleContextGenerator;
import com.fluentcommerce.util.test.executor.RuleRepository;
import com.fluentretail.api.client.ReadOnlyFluentApiClient;
import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.rule.meta.RuleInfo;
import com.fluentretail.rubix.v2.rule.Rule;
import com.fluentretail.rubix.workflow.RuleInstance;
import java.util.Map;

public class RuleExecutor {
    private MockApiClient api = new MockApiClient();
    private final RuleInstance rule;

    private RuleExecutor(RuleInstance rule) {
        this.rule = rule;
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> RuleExecutor mockNamedQuery(Class<Q> query, String file, String ... moreFiles) {
        this.api.mockNamedQuery(query, file, moreFiles);
        return this;
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> RuleExecutor mockNamedQuery(Class<Q> query, D data, D ... moreData) {
        this.api.mockNamedQuery(query, data, (Operation.Data[])moreData);
        return this;
    }

    public RuleExecutor mockDynamic(String file) {
        this.api.mockNamedQuery(DynamicEntityQuery.class, file, new String[0]);
        return this;
    }

    public RuleContextGenerator execute() {
        return this.execute(Event.builder().build());
    }

    public RuleContextGenerator execute(Event eventOverrides) {
        if (!GraphQLIntrospectionUtils.isSchemaLoaded()) {
            QueryMock.of(IntrospectionQuery.class, "graphql/introspection/schema.json", new String[0]).mockFor(this.api.get());
        }
        RuleRepository.ExecutableRule thisRule = RuleRepository.get(this.rule);
        RuleContextGenerator context = RuleContextGenerator.of(eventOverrides, this.api.get());
        thisRule.run(context.forRule(this.rule));
        TestUtils.validateEventAgainstProduces(thisRule, context, this.rule);
        return context;
    }

    public RuleExecutor resetApi() {
        this.api = new MockApiClient();
        return this;
    }

    public RuleExecutor replaceApi(MockApiClient api) {
        this.api = api;
        return this;
    }

    public RuleExecutor withLegacyClient(ReadOnlyFluentApiClient legacyExecutor) {
        this.api.withLegacyClient(legacyExecutor);
        return this;
    }

    public static RuleExecutor of(String ruleName, Map<String, Object> props) {
        return new RuleExecutor(RuleInstance.builder().name(ruleName).props(props).build());
    }

    public static RuleExecutor of(Class<? extends Rule> ruleClass, Map<String, Object> props) {
        return new RuleExecutor(RuleInstance.builder().name(ruleClass.getAnnotation(RuleInfo.class).name()).props(props).build());
    }
}

