/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.test.executor;

import com.fluentcommerce.util.test.TestUtils;
import com.fluentcommerce.util.test.executor.MockApiClient;
import com.fluentcommerce.util.test.executor.RuleRepository;
import com.fluentcommerce.util.test.executor.TestActions;
import com.fluentretail.api.v2.client.ReadOnlyFluentApiClient;
import com.fluentretail.api.v2.model.Entity;
import com.fluentretail.rubix.action.Action;
import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.exceptions.RuleNotFoundException;
import com.fluentretail.rubix.util.ValueConverter;
import com.fluentretail.rubix.v2.action.ActionFactory;
import com.fluentretail.rubix.v2.context.Context;
import com.fluentretail.rubix.workflow.RuleInstance;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleContextGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleContextGenerator.class);
    private final List<Action> actions = new ArrayList<Action>();
    private final LinkedList<Event> eventQueue = new LinkedList();
    private ReadOnlyFluentApiClient api;
    private final Entity primaryEntity;

    private RuleContextGenerator(Event event, ReadOnlyFluentApiClient api, Entity primaryEntity) {
        this.eventQueue.add(event);
        this.api = api;
        this.primaryEntity = primaryEntity;
    }

    public RuleContextGenerator mockApiClient(MockApiClient api) {
        this.api = api.get();
        return this;
    }

    public RuleContextGenerator pushEvent(Event event) {
        this.eventQueue.push(event);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public <T extends Action> List<T> getActionsOfType(Class<T> type) {
        return this.actions.stream().filter(a -> type.isAssignableFrom(a.getClass())).collect(Collectors.toList());
    }

    public <T extends Action> T getFirstActionOfType(Class<T> type) {
        List<T> typedActions = this.getActionsOfType(type);
        return (T)(!typedActions.isEmpty() ? (Action)typedActions.get(0) : null);
    }

    public <T extends Action> T getLastActionOfType(Class<T> type) {
        List<T> typedActions = this.getActionsOfType(type);
        return (T)(!typedActions.isEmpty() ? (Action)typedActions.get(typedActions.size() - 1) : null);
    }

    public boolean hasNextEvent() {
        return this.eventQueue.size() > 1;
    }

    public boolean nextEvent() {
        if (!this.hasNextEvent()) {
            return false;
        }
        this.eventQueue.poll();
        return true;
    }

    public Event getEvent() {
        return this.eventQueue.peek();
    }

    public RuleTestContext forRule(RuleInstance rule) {
        return new RuleTestContext(rule);
    }

    public RuleTestContext noRule() {
        return new RuleTestContext(null);
    }

    public static RuleContextGenerator of(ReadOnlyFluentApiClient api) {
        return RuleContextGenerator.of(Event.builder().build(), api);
    }

    public static RuleContextGenerator of(Event eventOverrides, ReadOnlyFluentApiClient api) {
        Event event = TestUtils.eventWithDefaults(eventOverrides);
        Entity primaryEntity = TestUtils.entityFromEvent(event);
        return new RuleContextGenerator(event, api, primaryEntity);
    }

    public final class RuleTestContext {
        private final RuleInstance rule;

        public RuleContext context() {
            return new RuleContext();
        }

        @Generated
        public RuleInstance getRule() {
            return this.rule;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RuleTestContext)) {
                return false;
            }
            RuleTestContext other = (RuleTestContext)o;
            RuleInstance this$rule = this.getRule();
            RuleInstance other$rule = other.getRule();
            return !(this$rule == null ? other$rule != null : !this$rule.equals(other$rule));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RuleInstance $rule = this.getRule();
            result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RuleContextGenerator.RuleTestContext(rule=" + this.getRule() + ")";
        }

        @ConstructorProperties(value={"rule"})
        @Generated
        public RuleTestContext(RuleInstance rule) {
            this.rule = rule;
        }

        public final class RuleContext
        implements Context {
            public String getProp(String name) {
                this.validateProp(RuleTestContext.this.rule.getName(), "String", name);
                return this.getProp(name, String.class);
            }

            public <T> T getProp(String name, Class<T> type) {
                this.validateProp(RuleTestContext.this.rule.getName(), type.getSimpleName(), name);
                return (T)(RuleTestContext.this.rule.getProps() != null && RuleTestContext.this.rule.getProps().containsKey(name) ? ValueConverter.convert(RuleTestContext.this.rule.getProps().get(name), type) : ValueConverter.convert(null, type));
            }

            public <T> List<T> getPropList(String name, Class<T> itemType) {
                this.validateProp(RuleTestContext.this.rule.getName(), "List of " + itemType.getSimpleName(), name);
                return RuleTestContext.this.rule.getProps() != null && RuleTestContext.this.rule.getProps().containsKey(name) ? ValueConverter.convertList(RuleTestContext.this.rule.getProps().get(name), itemType) : ValueConverter.convertList(null, itemType);
            }

            private void validateProp(String ruleName, String type, String prop) {
                block3: {
                    try {
                        Annotation annotation = (Annotation)RuleRepository.get(RuleTestContext.this.rule).params().get((Object)prop);
                        if (annotation == null) {
                            throw new IllegalArgumentException(String.format("Rule [%s] tried to use an undocumented %s prop: [%s]", ruleName, type, prop));
                        }
                    }
                    catch (RuleNotFoundException var5) {
                        if (!log.isDebugEnabled()) break block3;
                        log.debug("Rule '{}' with prop '{}' of type '{}' not found", new Object[]{ruleName, prop, type});
                    }
                }
            }

            public Event getEvent() {
                return (Event)RuleContextGenerator.this.eventQueue.peek();
            }

            public Entity getEntity() {
                return RuleContextGenerator.this.primaryEntity;
            }

            public ReadOnlyFluentApiClient api() {
                return RuleContextGenerator.this.api;
            }

            public ActionFactory action() {
                return TestActions.TestActionFactory.of(this);
            }

            public Context pushAction(Action action) {
                RuleContextGenerator.this.actions.add(action);
                return this;
            }

            public Context pushEvent(Event event) {
                RuleContextGenerator.this.eventQueue.add(event);
                return this;
            }
        }
    }
}

