/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.test.executor;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.response.OperationResponseParser;
import com.apollographql.apollo.internal.response.ScalarTypeAdapters;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fluentcommerce.graphql.queries.introspection.IntrospectionQuery;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.dynamic.graphql.DynamicDataTypes;
import com.fluentcommerce.util.dynamic.graphql.DynamicEntityQuery;
import com.fluentcommerce.util.dynamic.graphql.GraphQLIntrospectionUtils;
import com.fluentcommerce.util.test.executor.QueryMock;
import com.fluentretail.api.client.ObjectMapperFactory;
import com.fluentretail.api.v2.client.ReadOnlyFluentApiClient;
import com.fluentretail.graphql.type.CustomType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class QueryFileMock<D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>>
implements QueryMock {
    private static final Map<Class<?>, Object> DEFAULTS = ImmutableMap.of(String.class, (Object)"", Integer.class, (Object)1, List.class, (Object)ImmutableList.of(), Boolean.TYPE, (Object)true);
    public static final Map<ScalarType, CustomTypeAdapter> ADAPTERS = ImmutableMap.of((Object)CustomType.DATETIME, (Object)new DateAdapter(), (Object)CustomType.JSON, (Object)new JsonAdapter());
    private final Class<Q> query;
    private final String file;
    private final List<String> moreFiles;
    private static Map<String, Operation.Data> mockDataCache = new HashMap<String, Operation.Data>();

    @Override
    public void mockFor(ReadOnlyFluentApiClient mockClient) {
        Operation.Data first = this.toOperationData(this.query, this.file, mockClient);
        Object[] others = (Operation.Data[])this.moreFiles.stream().map(file -> this.toOperationData(this.query, (String)file, mockClient)).toArray(Operation.Data[]::new);
        Mockito.when((Object)mockClient.query((Query)ArgumentMatchers.isA(this.query))).thenReturn((Object)first, others);
    }

    private Operation.Data toOperationData(Class<Q> clazz, String filename, ReadOnlyFluentApiClient client) {
        String key = clazz.getName() + filename;
        if (mockDataCache.containsKey(key)) {
            return mockDataCache.get(key);
        }
        if (clazz == DynamicEntityQuery.class) {
            mockDataCache.put(key, (Operation.Data)QueryFileMock.loadDynamicQueryResultFromFile(client, filename));
            return mockDataCache.get(key);
        }
        mockDataCache.put(key, (Operation.Data)QueryFileMock.loadQueryResultFromFile(clazz, filename));
        return mockDataCache.get(key);
    }

    public static <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> T loadQueryResultFromFile(Class<Q> clazz, String filename) {
        try {
            Constructor<?>[] constructor = clazz.getDeclaredConstructors();
            Constructor<?> first = constructor[0];
            for (Class<?> parameterType : first.getParameterTypes()) {
                DEFAULTS.get(parameterType);
            }
            List params = ImmutableList.copyOf((Object[])first.getParameterTypes()).stream().map(DEFAULTS::get).collect(Collectors.toList());
            Query query = (Query)constructor[0].newInstance(params.toArray());
            OperationResponseParser parser = new OperationResponseParser((Operation)query, query.responseFieldMapper(), new ScalarTypeAdapters(ADAPTERS), (ResponseNormalizer)Mockito.mock(ResponseNormalizer.class));
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream is = classloader.getResourceAsStream(filename);
            BufferedSource bufferedSource = Okio.buffer((Source)Okio.source((InputStream)is));
            return (T)parser.parse(bufferedSource).data();
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("GQL mock failed for file: " + filename, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("GQL mock response file doesn't appear to exist: " + filename, e);
        }
    }

    public static DynamicDataTypes.QueryDynamicData loadDynamicQueryResultFromFile(ReadOnlyFluentApiClient mockClient, String filename) {
        if (!GraphQLIntrospectionUtils.isSchemaLoaded()) {
            QueryMock.of(IntrospectionQuery.class, "graphql/introspection/schema.json", new String[0]).mockFor(mockClient);
        }
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream is = classloader.getResourceAsStream(filename);
        return new DynamicDataTypes.QueryDynamicData((ObjectNode)JsonUtils.streamToNode((InputStream)is));
    }

    @Generated
    public Class<Q> getQuery() {
        return this.query;
    }

    @Generated
    public String getFile() {
        return this.file;
    }

    @Generated
    public List<String> getMoreFiles() {
        return this.moreFiles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryFileMock)) {
            return false;
        }
        QueryFileMock other = (QueryFileMock)o;
        Class<Q> this$query = this.getQuery();
        Class<Q> other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        List<String> this$moreFiles = this.getMoreFiles();
        List<String> other$moreFiles = other.getMoreFiles();
        return !(this$moreFiles == null ? other$moreFiles != null : !((Object)this$moreFiles).equals(other$moreFiles));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<Q> $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        List<String> $moreFiles = this.getMoreFiles();
        result = result * 59 + ($moreFiles == null ? 43 : ((Object)$moreFiles).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QueryFileMock(query=" + this.getQuery() + ", file=" + this.getFile() + ", moreFiles=" + this.getMoreFiles() + ")";
    }

    @ConstructorProperties(value={"query", "file", "moreFiles"})
    @Generated
    public QueryFileMock(Class<Q> query, String file, List<String> moreFiles) {
        this.query = query;
        this.file = file;
        this.moreFiles = moreFiles;
    }

    public static final class DateAdapter
    implements CustomTypeAdapter<Date> {
        final ISO8601DateFormat df = new ISO8601DateFormat();

        @Nonnull
        public Date decode(@Nonnull String value) {
            String strValue = null;
            try {
                try {
                    strValue = (String)ObjectMapperFactory.get().readValue(value, String.class);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.df.parse(strValue);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        @Nonnull
        public String encode(@Nonnull Date value) {
            return "\"" + this.df.format(value) + "\"";
        }
    }

    public static final class JsonAdapter
    implements CustomTypeAdapter<Object> {
        @Nonnull
        public Object decode(@Nonnull String source) {
            Object res;
            try {
                res = ObjectMapperFactory.get().readValue(source, JsonNode.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                res = source;
            }
            if (res instanceof TextNode) {
                return ((TextNode)res).asText();
            }
            return res;
        }

        @Nonnull
        public String encode(@Nonnull Object value) {
            String strValue;
            try {
                strValue = ObjectMapperFactory.get().writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                strValue = value.toString();
            }
            return strValue;
        }
    }
}

