/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.test.executor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.fluentcommerce.util.test.executor.QueryMock;
import com.fluentretail.api.v2.client.ReadOnlyFluentApiClient;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class MockApiClient {
    @Mock
    private ReadOnlyFluentApiClient api;
    @Mock
    private com.fluentretail.api.client.ReadOnlyFluentApiClient legacy;

    public MockApiClient() {
        MockitoAnnotations.openMocks((Object)this);
        Mockito.lenient().when((Object)this.api.getLegacyClient()).thenReturn((Object)this.legacy);
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> MockApiClient mockNamedQuery(Class<Q> query, String file, String ... moreFiles) {
        QueryMock.of(query, file, moreFiles).mockFor(this.api);
        return this;
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> MockApiClient mockNamedQuery(Class<Q> query, D data, D ... moreData) {
        QueryMock.of(query, data, moreData).mockFor(this.api);
        return this;
    }

    public ReadOnlyFluentApiClient get() {
        return this.api;
    }

    public com.fluentretail.api.client.ReadOnlyFluentApiClient getLegacy() {
        return this.api.getLegacyClient();
    }

    public MockApiClient withLegacyClient(com.fluentretail.api.client.ReadOnlyFluentApiClient legacy) {
        this.legacy = legacy;
        Mockito.when((Object)this.api.getLegacyClient()).thenReturn((Object)legacy);
        return this;
    }
}

