/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.test;

import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.test.executor.RuleContextGenerator;
import com.fluentcommerce.util.test.executor.RuleRepository;
import com.fluentcommerce.util.test.executor.TestActions;
import com.fluentretail.api.model.RubixEntity;
import com.fluentretail.api.v2.model.Entity;
import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.rule.meta.EventInfo;
import com.fluentretail.rubix.rule.meta.RuleInfo;
import com.fluentretail.rubix.v2.rule.Rule;
import com.fluentretail.rubix.workflow.RuleInstance;
import com.fluentretail.rubix.workflow.Workflow;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);

    public static Set<Class<? extends Rule>> gatherRules() {
        Reflections reflections = new Reflections("", new Scanner[0]);
        return reflections.getSubTypesOf(Rule.class).stream().filter(c -> c.isAnnotationPresent(RuleInfo.class)).collect(Collectors.toSet());
    }

    public static Event eventWithDefaults() {
        return TestUtils.eventWithDefaults(Event.builder().build());
    }

    public static Event eventWithDefaults(Event event) {
        return event.toBuilder().name(event.getName() == null ? "Single Rule Test" : event.getName()).accountId(event.getAccountId() == null ? "FLUENT" : event.getAccountId()).retailerId(event.getRetailerId() == null ? "1" : event.getRetailerId()).rootEntityType(event.getRootEntityType() == null ? "ORDER" : event.getRootEntityType()).rootEntityId(event.getRootEntityId() == null ? "100" : event.getRootEntityId()).rootEntityRef(event.getRootEntityRef() == null ? "REF-100" : event.getRootEntityRef()).entityType(event.getEntityType() == null ? "ORDER" : event.getEntityType()).entityId(event.getEntityId() == null ? "100" : event.getEntityId()).entityRef(event.getEntityRef() == null ? "REF-100" : event.getEntityRef()).entitySubtype(event.getEntitySubtype() == null ? "HD" : event.getEntitySubtype()).entityStatus(event.getEntityStatus() == null ? "CREATED" : event.getEntityStatus()).build();
    }

    public static Entity entityFromEvent(Event event) {
        return RubixEntity.builder().id(event.getEntityId()).ref(event.getEntityRef()).entityType(event.getEntityType()).type(event.getEntitySubtype()).status(event.getEntityStatus()).flexType(event.getFlexType()).flexVersion(1).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Workflow loadWorkflowFromFile(String filename) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try (InputStream is = classloader.getResourceAsStream(filename);){
            Workflow workflow = (Workflow)JsonUtils.anyToPojo((Object)JsonUtils.streamToNode((InputStream)is), Workflow.class);
            return workflow;
        }
        catch (IOException ex) {
            log.error("Load a workflow from a json file error: ", (Throwable)ex);
            return null;
        }
    }

    public static String getRuleName(String fullNameSpaceRuleName) {
        String[] rulePaths = fullNameSpaceRuleName.split("\\.");
        if (rulePaths.length > 1) {
            return rulePaths[rulePaths.length - 1];
        }
        return fullNameSpaceRuleName;
    }

    public static void validateEventAgainstProduces(RuleRepository.ExecutableRule executableRule, RuleContextGenerator ruleContextGenerator, RuleInstance ruleInstance) {
        RuleInfo ruleInfo = executableRule.info();
        for (TestActions.SendEventAction eventAction : ruleContextGenerator.getActionsOfType(TestActions.SendEventAction.class)) {
            if (executableRule instanceof RuleRepository.MockExecutableRule || !Arrays.stream(ruleInfo.produces()).noneMatch(eventInfo -> TestUtils.validateEventAgainstProduces(ruleContextGenerator.forRule(ruleInstance), eventInfo, eventAction.getEvent()))) continue;
            throw new IllegalArgumentException(String.format("Rule '%s' produced an event it hasn't declared in the `@RuleInfo.produces` annotation: %s", ruleInstance.getName(), eventAction.getEvent()));
        }
    }

    private static String renderFromContext(RuleContextGenerator.RuleTestContext context, String value) {
        return TestUtils.replace(value, Pattern.compile("\\{(.*?)}"), m -> {
            String sub = m.group(1);
            if (sub.startsWith("event.")) {
                switch (sub.substring(6)) {
                    case "entityType": {
                        return context.context().getEntity().getEntityType();
                    }
                    case "entitySubtype": {
                        return context.context().getEntity().getType();
                    }
                    case "status": {
                        return context.context().getEntity().getStatus();
                    }
                }
            } else {
                String prop = context.context().getProp(sub);
                return prop != null ? prop : "";
            }
            throw new IllegalArgumentException(String.format("No known substitution for `@RuleInfo.produces` template value '%s'", sub));
        });
    }

    private static String replace(String input, Pattern regex, Function<Matcher, String> callback) {
        StringBuffer resultString = new StringBuffer();
        Matcher regexMatcher = regex.matcher(input);
        while (regexMatcher.find()) {
            regexMatcher.appendReplacement(resultString, callback.apply(regexMatcher));
        }
        regexMatcher.appendTail(resultString);
        return resultString.toString();
    }

    private static boolean validateEventAgainstProduces(RuleContextGenerator.RuleTestContext context, EventInfo info, Event event) {
        if (!TestUtils.renderFromContext(context, info.eventName()).equalsIgnoreCase(event.getName())) {
            log.error(String.format("Name not matching: %s -vs- %s", info.eventName(), event.getName()));
            return false;
        }
        if (!TestUtils.renderFromContext(context, TestUtils.producesDefault(info.entityType(), "EVENT_TYPE", context.context().getEntity().getEntityType())).equalsIgnoreCase(event.getEntityType())) {
            log.error(String.format("EntityType not matching: %s -vs- %s", info.entityType(), event.getEntityType()));
            return false;
        }
        if (!TestUtils.renderFromContext(context, TestUtils.producesDefault(info.entitySubtype(), "EVENT_SUBTYPE", context.context().getEntity().getType())).equalsIgnoreCase(event.getEntitySubtype())) {
            log.error(String.format("EntitySubtype not matching: %s -vs- %s", info.entitySubtype(), event.getEntitySubtype()));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.status()) && !info.status().equals("EVENT_STATUS") && !TestUtils.renderFromContext(context, info.status()).equalsIgnoreCase(event.getEntityStatus())) {
            log.error(String.format("EntityStatus not matching: %s -vs- %s", info.status(), event.getEntityStatus()));
            return false;
        }
        return true;
    }

    private static String producesDefault(String value, String placeholder, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)value) || value.equals(placeholder)) {
            return defaultValue;
        }
        return value;
    }
}

