/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.graphql.type;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Utils;
import com.fluentretail.graphql.type.CustomType;
import java.io.IOException;
import javax.annotation.Nonnull;

public final class AttributeInput {
    @Nonnull
    private final String name;
    @Nonnull
    private final String type;
    @Nonnull
    private final Object value;

    AttributeInput(@Nonnull String name, @Nonnull String type, @Nonnull Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    @Nonnull
    public String name() {
        return this.name;
    }

    @Nonnull
    public String type() {
        return this.type;
    }

    @Nonnull
    public Object value() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public InputFieldMarshaller marshaller() {
        return new InputFieldMarshaller(){

            public void marshal(InputFieldWriter writer) throws IOException {
                writer.writeString("name", AttributeInput.this.name);
                writer.writeString("type", AttributeInput.this.type);
                writer.writeCustom("value", (ScalarType)CustomType.JSON, AttributeInput.this.value);
            }
        };
    }

    public static final class Builder {
        @Nonnull
        private String name;
        @Nonnull
        private String type;
        @Nonnull
        private Object value;

        Builder() {
        }

        public Builder name(@Nonnull String name) {
            this.name = name;
            return this;
        }

        public Builder type(@Nonnull String type) {
            this.type = type;
            return this;
        }

        public Builder value(@Nonnull Object value) {
            this.value = value;
            return this;
        }

        public AttributeInput build() {
            Utils.checkNotNull((Object)this.name, (Object)"name == null");
            Utils.checkNotNull((Object)this.type, (Object)"type == null");
            Utils.checkNotNull((Object)this.value, (Object)"value == null");
            return new AttributeInput(this.name, this.type, this.value);
        }
    }
}

