package com.fluentcommerce.util.test.executor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.fluentretail.api.v2.client.ReadOnlyFluentApiClient;

import java.util.Arrays;

public interface QueryMock {

    void mockFor(ReadOnlyFluentApiClient client);

    static <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> QueryFileMock<D, T, V, Q> of(Class<Q> query, final String file, final String... moreFiles) {
        return new QueryFileMock<>(query, file, Arrays.asList(moreFiles));
    }

    static <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> QueryInMemoryMock<D, T, V, Q> of(Class<Q> query, final D data, final D... moreData) {
        return new QueryInMemoryMock<>(query, data, moreData);
    }
}
