package com.fluentcommerce.util.test.executor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.fluentretail.api.v2.client.ReadOnlyFluentApiClient;
import lombok.AllArgsConstructor;
import lombok.Value;

import static org.mockito.ArgumentMatchers.isA;
import static org.mockito.Mockito.when;

@Value
@AllArgsConstructor
public class QueryInMemoryMock<D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D, T, V>> implements QueryMock {

    Class<Q> query;
    D data;
    D[] moreData;

    @Override
    public void mockFor(final ReadOnlyFluentApiClient client) {
        when(client.query(isA(query))).thenReturn(data, moreData);
    }
}
