package com.fluentcommerce.util.test.executor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.fluentretail.api.v2.client.ReadOnlyFluentApiClient;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.mockito.Mockito.lenient;
import static org.mockito.Mockito.when;


public class MockApiClient {
    @Mock
    private ReadOnlyFluentApiClient api;

    @Mock
    private com.fluentretail.api.client.ReadOnlyFluentApiClient legacy;

    public MockApiClient() {
        MockitoAnnotations.openMocks(this);
        lenient().when(api.getLegacyClient()).thenReturn(legacy);
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D,T,V>> MockApiClient mockNamedQuery(final Class<Q> query, final String file, final String... moreFiles) {
        QueryMock.of(query, file, moreFiles).mockFor(api);
        return this;
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, Q extends Query<D,T,V>> MockApiClient mockNamedQuery(final Class<Q> query, final D data, final D... moreData) {
        QueryMock.of(query, data, moreData).mockFor(api);
        return this;
    }

    public ReadOnlyFluentApiClient get() {
        return api;
    }

    public com.fluentretail.api.client.ReadOnlyFluentApiClient getLegacy() {
        return api.getLegacyClient();
    }

    public MockApiClient withLegacyClient(final com.fluentretail.api.client.ReadOnlyFluentApiClient legacy) {
        this.legacy = legacy;
        when(api.getLegacyClient()).thenReturn(legacy);
        return this;
    }
}
