package com.fluentcommerce.graphql.mutations;

import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.internal.Mutator;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import com.fluentretail.graphql.type.CustomType;
import com.fluentcommerce.graphql.type.UpdateOrderInput;
import java.io.IOException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Generated("Apollo GraphQL")
public final class UpdateOrderMutation implements Mutation<UpdateOrderMutation.Data, UpdateOrderMutation.Data, UpdateOrderMutation.Variables> {
  public static final String OPERATION_DEFINITION = "mutation UpdateOrder($input: UpdateOrderInput!) {\n"
      + "  updateOrder(input: $input) {\n"
      + "    __typename\n"
      + "    id\n"
      + "  }\n"
      + "}";

  public static final String QUERY_DOCUMENT = OPERATION_DEFINITION;

  private static final OperationName OPERATION_NAME = new OperationName() {
    @Override
    public String name() {
      return "UpdateOrder";
    }
  };

  private final UpdateOrderMutation.Variables variables;

  public UpdateOrderMutation(@Nonnull UpdateOrderInput input) {
    Utils.checkNotNull(input, "input == null");
    variables = new UpdateOrderMutation.Variables(input);
  }

  @Override
  public String operationId() {
    return "31b3497eaa4ccd5e4721d8f84e554032aa59b77d67c4ae6f42ee1da6459d124c";
  }

  @Override
  public String queryDocument() {
    return QUERY_DOCUMENT;
  }

  @Override
  public UpdateOrderMutation.Data wrapData(UpdateOrderMutation.Data data) {
    return data;
  }

  @Override
  public UpdateOrderMutation.Variables variables() {
    return variables;
  }

  @Override
  public ResponseFieldMapper<UpdateOrderMutation.Data> responseFieldMapper() {
    return new Data.Mapper();
  }

  public static Builder builder() {
    return new Builder();
  }

  @Override
  public OperationName name() {
    return OPERATION_NAME;
  }

  public static final class Builder {
    private @Nonnull UpdateOrderInput input;

    Builder() {
    }

    public Builder input(@Nonnull UpdateOrderInput input) {
      this.input = input;
      return this;
    }

    public UpdateOrderMutation build() {
      Utils.checkNotNull(input, "input == null");
      return new UpdateOrderMutation(input);
    }
  }

  public static final class Variables extends Operation.Variables {
    private final @Nonnull UpdateOrderInput input;

    private final transient Map<String, Object> valueMap = new LinkedHashMap<>();

    Variables(@Nonnull UpdateOrderInput input) {
      this.input = input;
      this.valueMap.put("input", input);
    }

    public @Nonnull UpdateOrderInput input() {
      return input;
    }

    @Override
    public Map<String, Object> valueMap() {
      return Collections.unmodifiableMap(valueMap);
    }

    @Override
    public InputFieldMarshaller marshaller() {
      return new InputFieldMarshaller() {
        @Override
        public void marshal(InputFieldWriter writer) throws IOException {
          writer.writeObject("input", input.marshaller());
        }
      };
    }
  }

  public static class Data implements Operation.Data {
    static final ResponseField[] $responseFields = {
      ResponseField.forObject("updateOrder", "updateOrder", new UnmodifiableMapBuilder<String, Object>(1)
        .put("input", new UnmodifiableMapBuilder<String, Object>(2)
          .put("kind", "Variable")
          .put("variableName", "input")
        .build())
      .build(), true, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nullable UpdateOrder updateOrder;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Data(@Nullable UpdateOrder updateOrder) {
      this.updateOrder = updateOrder;
    }

    public @Nullable UpdateOrder updateOrder() {
      return this.updateOrder;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeObject($responseFields[0], updateOrder != null ? updateOrder.marshaller() : null);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Data{"
          + "updateOrder=" + updateOrder
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Data) {
        Data that = (Data) o;
        return ((this.updateOrder == null) ? (that.updateOrder == null) : this.updateOrder.equals(that.updateOrder));
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= (updateOrder == null) ? 0 : updateOrder.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.updateOrder = updateOrder;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<Data> {
      final UpdateOrder.Mapper updateOrderFieldMapper = new UpdateOrder.Mapper();

      @Override
      public Data map(ResponseReader reader) {
        final UpdateOrder updateOrder = reader.readObject($responseFields[0], new ResponseReader.ObjectReader<UpdateOrder>() {
          @Override
          public UpdateOrder read(ResponseReader reader) {
            return updateOrderFieldMapper.map(reader);
          }
        });
        return new Data(updateOrder);
      }
    }

    public static final class Builder {
      private @Nullable UpdateOrder updateOrder;

      Builder() {
      }

      public Builder updateOrder(@Nullable UpdateOrder updateOrder) {
        this.updateOrder = updateOrder;
        return this;
      }

      public Builder updateOrder(@Nonnull Mutator<UpdateOrder.Builder> mutator) {
        Utils.checkNotNull(mutator, "mutator == null");
        UpdateOrder.Builder builder = this.updateOrder != null ? this.updateOrder.toBuilder() : UpdateOrder.builder();
        mutator.accept(builder);
        this.updateOrder = builder.build();
        return this;
      }

      public Data build() {
        return new Data(updateOrder);
      }
    }
  }

  public static class UpdateOrder {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("__typename", "__typename", null, false, Collections.<ResponseField.Condition>emptyList()),
      ResponseField.forCustomType("id", "id", null, false, CustomType.ID, Collections.<ResponseField.Condition>emptyList())
    };

    final @Nonnull String __typename;

    final @Nonnull String id;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public UpdateOrder(@Nonnull String __typename, @Nonnull String id) {
      this.__typename = Utils.checkNotNull(__typename, "__typename == null");
      this.id = Utils.checkNotNull(id, "id == null");
    }

    public @Nonnull String __typename() {
      return this.__typename;
    }

    /**
     *  ID of the object
     */
    public @Nonnull String id() {
      return this.id;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], __typename);
          writer.writeCustom((ResponseField.CustomTypeField) $responseFields[1], id);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "UpdateOrder{"
          + "__typename=" + __typename + ", "
          + "id=" + id
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof UpdateOrder) {
        UpdateOrder that = (UpdateOrder) o;
        return this.__typename.equals(that.__typename)
         && this.id.equals(that.id);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= __typename.hashCode();
        h *= 1000003;
        h ^= id.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public Builder toBuilder() {
      Builder builder = new Builder();
      builder.__typename = __typename;
      builder.id = id;
      return builder;
    }

    public static Builder builder() {
      return new Builder();
    }

    public static final class Mapper implements ResponseFieldMapper<UpdateOrder> {
      @Override
      public UpdateOrder map(ResponseReader reader) {
        final String __typename = reader.readString($responseFields[0]);
        final String id = reader.readCustomType((ResponseField.CustomTypeField) $responseFields[1]);
        return new UpdateOrder(__typename, id);
      }
    }

    public static final class Builder {
      private @Nonnull String __typename;

      private @Nonnull String id;

      Builder() {
      }

      public Builder __typename(@Nonnull String __typename) {
        this.__typename = __typename;
        return this;
      }

      public Builder id(@Nonnull String id) {
        this.id = id;
        return this;
      }

      public UpdateOrder build() {
        Utils.checkNotNull(__typename, "__typename == null");
        Utils.checkNotNull(id, "id == null");
        return new UpdateOrder(__typename, id);
      }
    }
  }
}
