/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.units;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNull;

class DistanceMeasurementUnitsTest {
    @Test
    void should_return_correct_enum_values_when_valid_strings_are_provided() {
        // Test KILOMETRES with different cases
        assertEquals(DistanceMeasurementUnits.KILOMETRES,
                DistanceMeasurementUnits.fromString("KILOMETRES"));
        assertEquals(DistanceMeasurementUnits.KILOMETRES,
                DistanceMeasurementUnits.fromString("kilometres"));
        assertEquals(DistanceMeasurementUnits.KILOMETRES,
                DistanceMeasurementUnits.fromString("Kilometres"));

        // Test MILES with different cases
        assertEquals(DistanceMeasurementUnits.MILES,
                DistanceMeasurementUnits.fromString("MILES"));
        assertEquals(DistanceMeasurementUnits.MILES,
                DistanceMeasurementUnits.fromString("miles"));
        assertEquals(DistanceMeasurementUnits.MILES,
                DistanceMeasurementUnits.fromString("Miles"));

        // Test existing values
        assertEquals(DistanceMeasurementUnits.METRES,
                DistanceMeasurementUnits.fromString("METRES"));
        assertEquals(DistanceMeasurementUnits.CENTIMETRES,
                DistanceMeasurementUnits.fromString("CENTIMETRES"));

        // Test invalid values should return null
        assertNull(DistanceMeasurementUnits.fromString("UNKNOWN"));
        assertNull(DistanceMeasurementUnits.fromString(""));
    }

    @Test
    void should_return_null_when_invalid_strings_are_provided() {
        // Test various invalid inputs
        assertNull(DistanceMeasurementUnits.fromString("INVALID"));
        assertNull(DistanceMeasurementUnits.fromString("123"));
        assertNull(DistanceMeasurementUnits.fromString("kilometer")); // singular form
        assertNull(DistanceMeasurementUnits.fromString("mile")); // singular form
        assertNull(DistanceMeasurementUnits.fromString("meter")); // singular form
        assertNull(DistanceMeasurementUnits.fromString("centimeter")); // singular form
    }

    @Test
    void should_return_correct_enum_when_using_fromString_with_default_value() {
        // Test the overloaded method with default value
        DistanceMeasurementUnits result1 = DistanceMeasurementUnits.fromString("UNKNOWN", DistanceMeasurementUnits.KILOMETRES);
        assertEquals(DistanceMeasurementUnits.KILOMETRES, result1);

        DistanceMeasurementUnits result2 = DistanceMeasurementUnits.fromString("", DistanceMeasurementUnits.MILES);
        assertEquals(DistanceMeasurementUnits.MILES, result2);

        DistanceMeasurementUnits result3 = DistanceMeasurementUnits.fromString("KILOMETRES", DistanceMeasurementUnits.MILES);
        assertEquals(DistanceMeasurementUnits.KILOMETRES, result3); // Should return the parsed value, not default
    }
}
