/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.units;

import org.jetbrains.annotations.NotNull;

/**
 * Defines the available distance measurements units
 */
public enum DistanceMeasurementUnits {

    CENTIMETRES, METRES, KILOMETRES, MILES;

    /**
     * Determine the distance unit based on the unit's text representation
     *
     * @param text distance unit's text representation
     * @return distance unit
     */
    public static DistanceMeasurementUnits fromString(@NotNull final String text) {
        for (DistanceMeasurementUnits unit : DistanceMeasurementUnits.values()) {
            if (unit.name().equalsIgnoreCase(text)) {
                return unit;
            }
        }
        return null;
    }

    /**
     * Determine the distance unit based on the unit's text representation, or use default if none match
     *
     * @param text         distance unit's text representation
     * @param defaultValue default unit to use in case none match
     * @return distance unit or default value
     */
    public static DistanceMeasurementUnits fromString(@NotNull final String text, DistanceMeasurementUnits defaultValue) {
        DistanceMeasurementUnits results = fromString(text);
        return results == null ? defaultValue : results;
    }

}
