/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.model.attribute;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Defines an entity attribute
 */
@Data
@AllArgsConstructor
@Builder(builderClassName = "Builder", toBuilder = true)
@JsonDeserialize(builder = Attribute.Builder.class)
public class Attribute {

    String name;
    String type;
    Object value;

    @JsonPOJOBuilder(withPrefix = "")
    public static final class Builder {}
}