/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.model;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * Use this class to define all the constants you will use in your rules.
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class Constants {

    public static final String ENTITY_TYPE_ORDER = "ORDER";
    public static final String ENTITY_TYPE_FULFILMENT_OPTIONS = "FULFILMENT_OPTIONS";
    public static final String ENTITY_TYPE_FULFILMENT_CHOICE = "FULFILMENT_CHOICE";

    public static final String ENTITY_SUBTYPE_ORDER_CC = "CC";
    public static final String ENTITY_SUBTYPE_ORDER_HD = "HD";
    public static final String DEFAULT = "DEFAULT";
    public static final String PROP_EVENT_NAME = "eventName";
    public static final String PROP_SYSTEM_REJECTED_LOC_REF = "systemRejectedLocationRef";
    public static final String PROP_SOURCING_PROFILE_REF = "sourcingProfileRef";
    public static final String ACTIVE = "ACTIVE";

}
