/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.inventory;

import com.fluentcommerce.util.sourcing.context.SourcingContext;

import java.util.List;

/**
 * Represents an interface for logic that modifies Virtual Positions after loading.
 */
public interface InventoryProcessor {

    /**
     * Processes the provided Virtual Positions and modifies them.
     *
     * @param sourcingContext {@link SourcingContext} of the processed Sourcing Request
     * @param positions       list of Virtual Positions that were loaded and need to be modified
     * @return list of processed Virtual Positions
     */
    List<VirtualPosition> process(final SourcingContext sourcingContext,
                                  final List<VirtualPosition> positions);

}
