/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Stores configuration information of the sourcing criterion which can be used to generate a setting configuration
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface SourcingCriterionInfo {
    /**
     * Name of the criterion
     *
     * @return name of the criterion
     */
    String name();

    /**
     * Type of the criterion
     *
     * @return type of the criterion
     */
    String type();

    /**
     * Tags of the criterion
     *
     * @return tags of the criterion
     */
    String[] tags() default {};

    /**
     * Label to be displayed for the criterion
     *
     * @return label to be displayed for the criterion
     */
    String label() default "";

    /**
     * Description label to be displayed for the criterion
     *
     * @return description label to be displayed for the criterion
     */
    String description() default "";

}
