/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParam;

import java.util.HashSet;
import java.util.Set;

import static com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils.getStrings;

@SourcingCriterionInfo(name = "locationNetworkExclusion",
        type = "fc.sourcing.criterion.locationNetworkExclusion",
        tags = {"Exclusion", "ATS-agnostic"})
public class LocationNetworkExclusionCriterion extends BaseSourcingCriterion {

    @SourcingCriterionParam(name = "value", component = "fc.field.multistring", exactSearch = true)
    private Set<String> bands;

    @Override
    public void parseParams(final JsonNode params) {
        bands = new HashSet<>(getStrings(params, "value"));
    }

    @Override
    protected float execute(final SourcingCriteriaUtils.CriterionContext criterionContext) {
        return criterionContext.getLap().getLocation().getNetworks().stream()
                .anyMatch(network -> bands.contains(network))
                ? -1f : 1f;
    }

}
