/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context.model;

import com.fluentretail.api.model.attribute.Attribute;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

@Data
@Builder(toBuilder = true)
@AllArgsConstructor
public class OrderItem {

    private String id;
    private String ref;
    private int quantity;
    private Double paidPrice;
    private String currency;
    private Double price;
    private Double taxPrice;
    private Double totalPrice;
    private Double totalTaxPrice;
    private String status;
    private Product product;
    private List<Attribute> attributes;
    private FulfilmentChoice fulfilmentChoice;

}
