/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context.model;

import com.fluentretail.api.model.attribute.Attribute;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@Builder
@AllArgsConstructor
public class Location {

    private String id;
    private String ref;
    private Date createdOn;
    private Date updatedOn;
    private String type;
    private String status;
    private String name;
    private String supportPhoneNumber;
    private String defaultCarrier;
    private String defaultCarrierName;
    private Address primaryAddress;
    private Retailer retailer;
    private List<String> networks;
    private OpeningSchedule openingSchedule;
    private List<Attribute> attributes;

}
