/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context.loader;

import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.context.UnfulfilledItemProcessor;
import com.fluentretail.rubix.v2.context.Context;

/**
 * Interface for components that load and construct a {@link SourcingContext} from a given {@link Context}.
 * <p>
 * This abstraction allows different implementations to define how sourcing data is retrieved (e.g. via GraphQL)
 * and how it is mapped to a {@link SourcingContext}, depending on the entity type being processed (e.g. Order, FulfilmentChoice).
 * <p>
 * Common use cases include strategy-based sourcing, where different loaders encapsulate entity-specific loading logic.
 */
public interface SourcingContextLoader {

    /**
     * Loads and constructs a {@link SourcingContext} using the provided Rubix {@link Context}
     * and a helper to compute unfulfilled items.
     * <p>
     * Implementations are expected to retrieve data from an external source (e.g. via GraphQL)
     * and map it into a domain-specific {@link SourcingContext}.
     *
     * @param context                  the rule execution context containing the triggering event and properties
     * @param unfulfilledItemProcessor helper for determining unfulfilled order items from the response
     * @return the fully constructed {@link SourcingContext}
     */
    SourcingContext load(final Context context,
                         final UnfulfilledItemProcessor unfulfilledItemProcessor);

}
