/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.context;

import com.fluentcommerce.util.sourcing.context.model.Customer;
import com.fluentcommerce.util.sourcing.context.model.Fulfilment;
import com.fluentcommerce.util.sourcing.context.model.FulfilmentChoice;
import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentretail.api.model.attribute.Attribute;
import lombok.Builder;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * Default implementation of {@link SourcingContext}
 */
@Data
@Builder(toBuilder = true, builderClassName = "DefaultSourcingContextBuilder")
public class DefaultSourcingContext implements SourcingContext {

    private String id;
    private String ref;
    private String ref2;
    private String tag1;
    private String tag2;
    private String tag3;
    private String type;
    private String status;
    private Date createdOn;
    private Date updatedOn;
    private List<Attribute> attributes;
    private Double totalPrice;
    private Double totalTaxPrice;
    private FulfilmentChoice fulfilmentChoice;
    private List<OrderItem> items;
    private List<OrderItem> unfulfilledItems;
    private List<Fulfilment> fulfilments;
    private Customer customer;

    /**
     * Default implementation of the {@link com.fluentcommerce.util.sourcing.context.SourcingContext.SourcingContextBuilder}
     * which is implemented by the {@code @Builder} annotation
     */
    public static class DefaultSourcingContextBuilder implements SourcingContextBuilder {
    }

}
