/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.condition;

/**
 * Contains constants and enumerations used in the evaluation of sourcing conditions.
 *
 * <p>This class defines the available scopes for condition evaluation </p>
 */
public class SourcingConditionConstants {

    /**
     * Defines the logical scope for evaluating multiple sourcing conditions.
     *
     * <ul>
     *     <li>{@code ALL} — all conditions must be true</li>
     *     <li>{@code ANY} — at least one condition must be true</li>
     *     <li>{@code NONE} — none of the conditions must be true</li>
     * </ul>
     */
    public enum SourcingConditionScope {
        ALL, ANY, NONE
    }
}

