/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.sourcing.SourcingUtils;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.criterion.RejectedLocationExclusionCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaTypeRegistry;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriterion;
import com.fluentcommerce.util.sourcing.profile.SourcingStrategy;
import com.fluentcommerce.util.units.DistanceMeasurementUnits;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class SourcingCriteriaUtils {
    @NotNull
    public static Float[] getFloats(JsonNode params, String fieldName) {
        JsonNode array = params.get(fieldName);
        return array != null && array.isArray() ? (Float[])StreamSupport.stream(array.spliterator(), false).filter(JsonNode::isNumber).map(JsonNode::asDouble).map(Double::floatValue).toArray(Float[]::new) : new Float[]{};
    }

    public static DistanceMeasurementUnits getDistanceUnits(JsonNode params, String fieldName) {
        return DistanceMeasurementUnits.fromString((String)Optional.ofNullable(params).map(p -> p.get(fieldName)).filter(JsonNode::isTextual).map(JsonNode::asText).orElse(DistanceMeasurementUnits.KILOMETRES.name()));
    }

    @NotNull
    public static List<String> getStrings(JsonNode params, String fieldName) {
        JsonNode bandsArray = params.get(fieldName);
        return bandsArray != null && bandsArray.isArray() ? StreamSupport.stream(bandsArray.spliterator(), false).filter(JsonNode::isTextual).map(JsonNode::textValue).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static CriteriaArray getCriteria(SourcingStrategy strategy, CriteriaArray defaultCriteria) {
        if (strategy == null || strategy.getSourcingCriteria() == null) {
            return defaultCriteria;
        }
        CriteriaArray strategyCriteria = CriteriaArray.of(strategy.getSourcingCriteria().stream().map(c -> {
            JsonNode node = (JsonNode)Optional.ofNullable(c.getParams()).map(JsonUtils::objectToNode).orElseGet(() -> ((JsonNodeFactory)JsonNodeFactory.instance).objectNode());
            SourcingCriterion criterion = SourcingCriteriaTypeRegistry.getSourcingCriterion(c.getType());
            criterion.parseParams(node);
            return criterion;
        }).collect(Collectors.toList()));
        ArrayList<SourcingCriterion> mergedCriteria = new ArrayList<SourcingCriterion>();
        mergedCriteria.addAll(defaultCriteria.getCriteria() != null ? defaultCriteria.getCriteria() : Collections.emptyList());
        mergedCriteria.addAll(strategyCriteria.getCriteria() != null ? strategyCriteria.getCriteria() : Collections.emptyList());
        return CriteriaArray.of(mergedCriteria);
    }

    public static CriteriaArray getDefaultCriteria() {
        RejectedLocationExclusionCriterion locationExclusionCriterion = new RejectedLocationExclusionCriterion();
        return CriteriaArray.of(locationExclusionCriterion);
    }

    private SourcingCriteriaUtils() {
    }

    public static interface CriterionContext {
        public SourcingContext getSourcingContext();

        public SourcingUtils.LocationAndPositions getLap();
    }

    public static final class DefaultCriterionContext
    implements CriterionContext {
        private final SourcingUtils.LocationAndPositions lap;
        private final SourcingContext sourcingContext;

        DefaultCriterionContext(SourcingUtils.LocationAndPositions lap, SourcingContext sourcingContext) {
            this.lap = lap;
            this.sourcingContext = sourcingContext;
        }

        public static DefaultCriterionContextBuilder builder() {
            return new DefaultCriterionContextBuilder();
        }

        @Override
        public SourcingUtils.LocationAndPositions getLap() {
            return this.lap;
        }

        @Override
        public SourcingContext getSourcingContext() {
            return this.sourcingContext;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultCriterionContext)) {
                return false;
            }
            DefaultCriterionContext other = (DefaultCriterionContext)o;
            SourcingUtils.LocationAndPositions this$lap = this.getLap();
            SourcingUtils.LocationAndPositions other$lap = other.getLap();
            if (this$lap == null ? other$lap != null : !((Object)this$lap).equals(other$lap)) {
                return false;
            }
            SourcingContext this$sourcingContext = this.getSourcingContext();
            SourcingContext other$sourcingContext = other.getSourcingContext();
            return !(this$sourcingContext == null ? other$sourcingContext != null : !this$sourcingContext.equals(other$sourcingContext));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SourcingUtils.LocationAndPositions $lap = this.getLap();
            result = result * 59 + ($lap == null ? 43 : ((Object)$lap).hashCode());
            SourcingContext $sourcingContext = this.getSourcingContext();
            result = result * 59 + ($sourcingContext == null ? 43 : $sourcingContext.hashCode());
            return result;
        }

        public String toString() {
            return "SourcingCriteriaUtils.DefaultCriterionContext(lap=" + this.getLap() + ", sourcingContext=" + this.getSourcingContext() + ")";
        }

        public static class DefaultCriterionContextBuilder {
            private SourcingUtils.LocationAndPositions lap;
            private SourcingContext sourcingContext;

            DefaultCriterionContextBuilder() {
            }

            public DefaultCriterionContextBuilder lap(SourcingUtils.LocationAndPositions lap) {
                this.lap = lap;
                return this;
            }

            public DefaultCriterionContextBuilder sourcingContext(SourcingContext sourcingContext) {
                this.sourcingContext = sourcingContext;
                return this;
            }

            public DefaultCriterionContext build() {
                return new DefaultCriterionContext(this.lap, this.sourcingContext);
            }

            public String toString() {
                return "SourcingCriteriaUtils.DefaultCriterionContext.DefaultCriterionContextBuilder(lap=" + this.lap + ", sourcingContext=" + this.sourcingContext + ")";
            }
        }
    }

    public static final class CriteriaArray {
        private final List<SourcingCriterion> criteria;

        public static CriteriaArray of(SourcingCriterion ... criteria) {
            return new CriteriaArray((List<SourcingCriterion>)ImmutableList.copyOf((Object[])criteria));
        }

        public static CriteriaArray of(List<SourcingCriterion> criteria) {
            return new CriteriaArray((List<SourcingCriterion>)ImmutableList.copyOf(criteria));
        }

        public float[] apply(CriterionContext criterionContext) {
            float[] rating = new float[this.criteria.size()];
            for (int i = 0; i < this.criteria.size(); ++i) {
                rating[i] = this.criteria.get(i).apply(criterionContext);
            }
            return rating;
        }

        public void normalize(List<float[]> ratingsList) {
            int i;
            int size = this.criteria.size();
            float[] min = new float[size];
            float[] max = new float[size];
            Arrays.fill(min, Float.POSITIVE_INFINITY);
            Arrays.fill(max, Float.NEGATIVE_INFINITY);
            for (float[] ratings : ratingsList) {
                for (i = 0; i < size; ++i) {
                    float rating = ratings[i];
                    if (rating == -1.0f) continue;
                    min[i] = Math.min(rating, min[i]);
                    max[i] = Math.max(rating, max[i]);
                }
            }
            for (float[] ratings : ratingsList) {
                for (i = 0; i < size; ++i) {
                    ratings[i] = this.criteria.get(i).normalize(min[i], max[i], ratings[i]);
                }
            }
        }

        @ConstructorProperties(value={"criteria"})
        public CriteriaArray(List<SourcingCriterion> criteria) {
            this.criteria = criteria;
        }

        public List<SourcingCriterion> getCriteria() {
            return this.criteria;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CriteriaArray)) {
                return false;
            }
            CriteriaArray other = (CriteriaArray)o;
            List<SourcingCriterion> this$criteria = this.getCriteria();
            List<SourcingCriterion> other$criteria = other.getCriteria();
            return !(this$criteria == null ? other$criteria != null : !((Object)this$criteria).equals(other$criteria));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<SourcingCriterion> $criteria = this.getCriteria();
            result = result * 59 + ($criteria == null ? 43 : ((Object)$criteria).hashCode());
            return result;
        }

        public String toString() {
            return "SourcingCriteriaUtils.CriteriaArray(criteria=" + this.getCriteria() + ")";
        }
    }
}

