/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fluentcommerce.util.sourcing.SourcingCriteriaSettingGenerator;
import com.fluentcommerce.util.sourcing.criterion.InventoryAvailabilityBandedCriterion;
import com.fluentcommerce.util.sourcing.criterion.InventoryAvailabilityCriterion;
import com.fluentcommerce.util.sourcing.criterion.InventoryAvailabilityExclusionCriterion;
import com.fluentcommerce.util.sourcing.criterion.LocationDailyCapacityCriterion;
import com.fluentcommerce.util.sourcing.criterion.LocationDistanceBandedCriterion;
import com.fluentcommerce.util.sourcing.criterion.LocationDistanceCriterion;
import com.fluentcommerce.util.sourcing.criterion.LocationDistanceExclusionCriterion;
import com.fluentcommerce.util.sourcing.criterion.LocationNetworkExclusionCriterion;
import com.fluentcommerce.util.sourcing.criterion.LocationTypeExclusionCriterion;
import com.fluentcommerce.util.sourcing.criterion.NetworkPriorityCriterion;
import com.fluentcommerce.util.sourcing.criterion.OrderValueCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriterion;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SourcingCriteriaTypeRegistry {
    private static final Map<String, Class<? extends SourcingCriterion>> typeNameToClassMap = new ConcurrentHashMap<String, Class<? extends SourcingCriterion>>();

    public static void register(String typeName, Class<? extends SourcingCriterion> clazz) {
        typeNameToClassMap.put(typeName, clazz);
    }

    public static Class<? extends SourcingCriterion> getSourcingCriterionType(String typeName) {
        Class<? extends SourcingCriterion> clazz = typeNameToClassMap.get(typeName);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown Sourcing Criterion type: " + typeName);
        }
        return clazz;
    }

    public static SourcingCriterion getSourcingCriterion(String typeName) {
        Class<? extends SourcingCriterion> clazz = SourcingCriteriaTypeRegistry.getSourcingCriterionType(typeName);
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static void generateSourcingCriteriaSetting() throws IOException, URISyntaxException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        ArrayNode resultArray = mapper.createArrayNode();
        for (String typeName : SourcingCriteriaTypeRegistry.getTypeNameToClassMap().keySet()) {
            SourcingCriterion criterion = SourcingCriteriaTypeRegistry.getSourcingCriterion(typeName);
            resultArray.add((JsonNode)criterion.toJson());
        }
        Path jarOrClasses = Paths.get(SourcingCriteriaSettingGenerator.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        Path baseDir = Files.isRegularFile(jarOrClasses, new LinkOption[0]) ? jarOrClasses.getParent() : jarOrClasses;
        File outputFile = baseDir.resolve("SourcingCriteriaSetting.json").toFile();
        outputFile.getParentFile().mkdirs();
        mapper.writeValue(outputFile, (Object)resultArray);
    }

    private SourcingCriteriaTypeRegistry() {
    }

    public static Map<String, Class<? extends SourcingCriterion>> getTypeNameToClassMap() {
        return typeNameToClassMap;
    }

    static {
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.locationDistanceExclusion", LocationDistanceExclusionCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.locationTypeExclusion", LocationTypeExclusionCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.locationDistance", LocationDistanceCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.locationDistanceBanded", LocationDistanceBandedCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.locationDailyCapacity", LocationDailyCapacityCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.networkPriority", NetworkPriorityCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.inventoryAvailabilityExclusion", InventoryAvailabilityExclusionCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.inventoryAvailability", InventoryAvailabilityCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.inventoryAvailabilityBanded", InventoryAvailabilityBandedCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.orderValue", OrderValueCriterion.class);
        SourcingCriteriaTypeRegistry.register("fc.sourcing.criterion.locationNetworkExclusion", LocationNetworkExclusionCriterion.class);
    }
}

