/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentcommerce.util.sourcing.criterion.BaseSourcingCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import java.util.List;
import java.util.Optional;

@SourcingCriterionInfo(name="orderValue", type="fc.sourcing.criterion.orderValue", tags={"ATS-dependent"})
public class OrderValueCriterion
extends BaseSourcingCriterion {
    @Override
    protected float execute(SourcingCriteriaUtils.CriterionContext criterionContext) {
        if (criterionContext.getLap().getQuantities() == null) {
            return 0.0f;
        }
        List<OrderItem> items = criterionContext.getSourcingContext().getUnfulfilledItems();
        float total = 0.0f;
        float filled = 0.0f;
        for (int i = 0; i < items.size(); ++i) {
            OrderItem item = items.get(i);
            double itemValue = Optional.ofNullable(item.getPaidPrice()).orElse(0.0) + Optional.ofNullable(item.getTaxPrice()).orElse(0.0);
            double requested = (double)item.getQuantity() * itemValue;
            total += (float)requested;
            filled += (float)Math.min(requested, (double)criterionContext.getLap().getQuantities()[i] * itemValue);
        }
        if (total == 0.0f) {
            return 0.0f;
        }
        return filled / total;
    }
}

