/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fluentcommerce.util.sourcing.context.model.Location;
import com.fluentcommerce.util.sourcing.criterion.BaseSourcingCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParam;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@SourcingCriterionInfo(name="networkPriority", type="fc.sourcing.criterion.networkPriority", tags={"ATS-agnostic"})
public class NetworkPriorityCriterion
extends BaseSourcingCriterion {
    @SourcingCriterionParam(name="value", component="fc.field.multistring", exactSearch=true)
    private List<String> bands;

    @Override
    public void parseParams(JsonNode params) {
        this.bands = SourcingCriteriaUtils.getStrings(params, "value");
    }

    @Override
    protected float execute(SourcingCriteriaUtils.CriterionContext criterionContext) {
        Set networks = Optional.ofNullable(criterionContext.getLap().getLocation()).map(Location::getNetworks).map(HashSet::new).orElse(null);
        if (networks == null) {
            return 0.0f;
        }
        for (int i = 0; i < this.bands.size(); ++i) {
            if (!networks.contains(this.bands.get(i))) continue;
            return this.bands.size() - i;
        }
        return 0.0f;
    }
}

