/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fluentcommerce.util.sourcing.criterion.BaseSourcingCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParam;
import java.util.HashSet;
import java.util.Set;

@SourcingCriterionInfo(name="locationNetworkExclusion", type="fc.sourcing.criterion.locationNetworkExclusion", tags={"Exclusion", "ATS-agnostic"})
public class LocationNetworkExclusionCriterion
extends BaseSourcingCriterion {
    @SourcingCriterionParam(name="value", component="fc.field.multistring", exactSearch=true)
    private Set<String> bands;

    @Override
    public void parseParams(JsonNode params) {
        this.bands = new HashSet<String>(SourcingCriteriaUtils.getStrings(params, "value"));
    }

    @Override
    protected float execute(SourcingCriteriaUtils.CriterionContext criterionContext) {
        return criterionContext.getLap().getLocation().getNetworks().stream().anyMatch(network -> this.bands.contains(network)) ? -1.0f : 1.0f;
    }
}

