/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fluentcommerce.util.sourcing.LocationUtils;
import com.fluentcommerce.util.sourcing.SourcingUtils;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.context.model.Address;
import com.fluentcommerce.util.sourcing.context.model.FulfilmentChoice;
import com.fluentcommerce.util.sourcing.context.model.Location;
import com.fluentcommerce.util.sourcing.criterion.BaseSourcingCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import java.util.Optional;

@SourcingCriterionInfo(name="locationDistance", type="fc.sourcing.criterion.locationDistance", tags={"ATS-agnostic"})
public class LocationDistanceCriterion
extends BaseSourcingCriterion {
    @Override
    protected float execute(SourcingCriteriaUtils.CriterionContext criterionContext) {
        Double lat = Optional.ofNullable(criterionContext.getSourcingContext()).map(SourcingContext::getFulfilmentChoice).map(FulfilmentChoice::getAddress).map(Address::getLatitude).orElse(null);
        Double lon = Optional.ofNullable(criterionContext.getSourcingContext()).map(SourcingContext::getFulfilmentChoice).map(FulfilmentChoice::getAddress).map(Address::getLongitude).orElse(null);
        if (lat == null || lon == null) {
            return 0.0f;
        }
        Double locationLat = Optional.ofNullable(criterionContext.getLap()).map(SourcingUtils.LocationAndPositions::getLocation).map(Location::getPrimaryAddress).map(Address::getLatitude).orElse(null);
        Double locationLon = Optional.ofNullable(criterionContext.getLap()).map(SourcingUtils.LocationAndPositions::getLocation).map(Location::getPrimaryAddress).map(Address::getLongitude).orElse(null);
        if (locationLat == null || locationLon == null) {
            return 0.0f;
        }
        double distanceInKm = LocationUtils.distanceInMetres(lat, lon, locationLat, locationLon) / 1000.0;
        return (float)distanceInKm;
    }

    @Override
    public float normalize(float min, float max, float rating) {
        if (rating == -1.0f) {
            return -1.0f;
        }
        if (Float.compare(min, max) == 0) {
            return Float.compare(min, 0.0f) > 0 ? 0.0f : 1.0f;
        }
        return (max - rating) / (max - min);
    }
}

