/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fluentcommerce.util.sourcing.LocationUtils;
import com.fluentcommerce.util.sourcing.SourcingUtils;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.context.model.Address;
import com.fluentcommerce.util.sourcing.context.model.FulfilmentChoice;
import com.fluentcommerce.util.sourcing.context.model.Location;
import com.fluentcommerce.util.sourcing.criterion.BaseSourcingCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParam;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParamSelectComponentOption;
import com.fluentcommerce.util.units.DistanceMeasurementUnits;
import java.util.Optional;

@SourcingCriterionInfo(name="locationDistanceBanded", type="fc.sourcing.criterion.locationDistanceBanded", tags={"ATS-agnostic"})
public class LocationDistanceBandedCriterion
extends BaseSourcingCriterion {
    @SourcingCriterionParam(name="value", component="fc.field.multistring", type="number")
    private Float[] bands;
    @SourcingCriterionParam(name="valueUnit", component="select", selectComponentOptions={@SourcingCriterionParamSelectComponentOption(label="fc.sourcing.criterion.locationDistanceBanded.valueunit.kilometres", value="kilometres"), @SourcingCriterionParamSelectComponentOption(label="fc.sourcing.criterion.locationDistanceBanded.valueunit.miles", value="miles")})
    private DistanceMeasurementUnits distanceUnit;

    @Override
    public void parseParams(JsonNode params) {
        this.bands = SourcingCriteriaUtils.getFloats(params, "value");
        this.distanceUnit = SourcingCriteriaUtils.getDistanceUnits(params, "valueUnit");
    }

    @Override
    protected float execute(SourcingCriteriaUtils.CriterionContext criterionContext) {
        if (this.distanceUnit != DistanceMeasurementUnits.KILOMETRES && this.distanceUnit != DistanceMeasurementUnits.MILES) {
            return 0.0f;
        }
        Double lat = Optional.ofNullable(criterionContext.getSourcingContext()).map(SourcingContext::getFulfilmentChoice).map(FulfilmentChoice::getAddress).map(Address::getLatitude).orElse(null);
        Double lon = Optional.ofNullable(criterionContext.getSourcingContext()).map(SourcingContext::getFulfilmentChoice).map(FulfilmentChoice::getAddress).map(Address::getLongitude).orElse(null);
        if (lat == null || lon == null) {
            return 0.0f;
        }
        if (this.bands.length == 0) {
            return 0.0f;
        }
        Double locationLat = Optional.ofNullable(criterionContext.getLap()).map(SourcingUtils.LocationAndPositions::getLocation).map(Location::getPrimaryAddress).map(Address::getLatitude).orElse(null);
        Double locationLon = Optional.ofNullable(criterionContext.getLap()).map(SourcingUtils.LocationAndPositions::getLocation).map(Location::getPrimaryAddress).map(Address::getLongitude).orElse(null);
        if (locationLat == null || locationLon == null) {
            return 0.0f;
        }
        double distance = LocationUtils.calculateDistance(lat, lon, locationLat, locationLon, this.distanceUnit);
        for (int i = this.bands.length - 1; i >= 0; --i) {
            if (!(distance > (double)this.bands[i].floatValue())) continue;
            return this.bands.length - 1 - i;
        }
        return this.bands.length;
    }
}

