/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentcommerce.util.sourcing.criterion.BaseSourcingCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParam;
import java.util.List;
import java.util.Optional;

@SourcingCriterionInfo(name="inventoryAvailabilityExclusion", type="fc.sourcing.criterion.inventoryAvailabilityExclusion", tags={"Exclusion", "ATS-dependent"})
public class InventoryAvailabilityExclusionCriterion
extends BaseSourcingCriterion {
    @SourcingCriterionParam(name="value", component="integer")
    private Double threshold;

    @Override
    public void parseParams(JsonNode params) {
        this.threshold = Optional.ofNullable(params).map(p -> p.get("value")).filter(JsonNode::isNumber).map(JsonNode::asDouble).orElse(null);
    }

    @Override
    protected float execute(SourcingCriteriaUtils.CriterionContext criterionContext) {
        if (criterionContext.getLap().getQuantities() == null) {
            return 0.0f;
        }
        if (this.threshold == null) {
            return 0.0f;
        }
        List<OrderItem> items = criterionContext.getSourcingContext().getUnfulfilledItems();
        int total = 0;
        int filled = 0;
        for (int i = 0; i < items.size(); ++i) {
            int requested = items.get(i).getQuantity();
            total += requested;
            filled += criterionContext.getLap().getQuantities()[i];
        }
        if (total == 0) {
            return 1.0f;
        }
        return (double)((float)filled / (float)total) * 100.0 >= this.threshold ? 1.0f : -1.0f;
    }
}

