/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentcommerce.util.sourcing.criterion.BaseSourcingCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import java.util.List;

@SourcingCriterionInfo(name="inventoryAvailability", type="fc.sourcing.criterion.inventoryAvailability", tags={"ATS-dependent"})
public class InventoryAvailabilityCriterion
extends BaseSourcingCriterion {
    @Override
    protected float execute(SourcingCriteriaUtils.CriterionContext criterionContext) {
        if (criterionContext.getLap().getQuantities() == null) {
            return 0.0f;
        }
        List<OrderItem> items = criterionContext.getSourcingContext().getUnfulfilledItems();
        int total = 0;
        int filled = 0;
        for (int i = 0; i < items.size(); ++i) {
            int requested = items.get(i).getQuantity();
            total += requested;
            filled += criterionContext.getLap().getQuantities()[i];
        }
        if (total == 0) {
            return 1.0f;
        }
        return (float)filled / (float)total;
    }
}

