/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentcommerce.util.sourcing.criterion.BaseSourcingCriterion;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParam;
import java.util.List;

@SourcingCriterionInfo(name="inventoryAvailabilityBanded", type="fc.sourcing.criterion.inventoryAvailabilityBanded", tags={"ATS-dependent"})
public class InventoryAvailabilityBandedCriterion
extends BaseSourcingCriterion {
    @SourcingCriterionParam(name="value", component="fc.field.multistring", type="number")
    private Float[] bands;

    @Override
    public void parseParams(JsonNode params) {
        this.bands = SourcingCriteriaUtils.getFloats(params, "value");
    }

    @Override
    protected float execute(SourcingCriteriaUtils.CriterionContext criterionContext) {
        if (criterionContext.getLap().getQuantities() == null) {
            return 0.0f;
        }
        if (this.bands.length == 0) {
            return 0.0f;
        }
        List<OrderItem> items = criterionContext.getSourcingContext().getUnfulfilledItems();
        int total = 0;
        int filled = 0;
        for (int i = 0; i < items.size(); ++i) {
            int requested = items.get(i).getQuantity();
            total += requested;
            filled += criterionContext.getLap().getQuantities()[i];
        }
        if (total == 0) {
            return 1.0f;
        }
        float availability = (float)filled / (float)total * 100.0f;
        for (int i = this.bands.length - 1; i >= 0; --i) {
            if (!(availability > this.bands[i].floatValue())) continue;
            return i + 1;
        }
        return 0.0f;
    }
}

