/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.criterion;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriterion;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionInfo;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParam;
import com.fluentcommerce.util.sourcing.criterion.annotation.SourcingCriterionParamSelectComponentOption;
import java.lang.reflect.Field;

public abstract class BaseSourcingCriterion
implements SourcingCriterion {
    @Override
    public float apply(SourcingCriteriaUtils.CriterionContext criterionContext) {
        this.preExecution(criterionContext);
        float result = this.execute(criterionContext);
        this.postExecution(criterionContext, result);
        return result;
    }

    protected void preExecution(SourcingCriteriaUtils.CriterionContext criterionContext) {
    }

    protected void postExecution(SourcingCriteriaUtils.CriterionContext criterionContext, float result) {
    }

    protected abstract float execute(SourcingCriteriaUtils.CriterionContext var1);

    @Override
    public ObjectNode toJson() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        SourcingCriterionInfo annotation = this.getClass().getAnnotation(SourcingCriterionInfo.class);
        if (annotation == null) {
            return root;
        }
        root.put("name", annotation.name());
        root.put("type", annotation.type());
        this.addTags(annotation, root, mapper);
        this.addOptionalFields(annotation, root);
        this.addParams(root, mapper);
        return root;
    }

    private void addTags(SourcingCriterionInfo annotation, ObjectNode root, ObjectMapper mapper) {
        ArrayNode tagsArray = mapper.createArrayNode();
        for (String tag : annotation.tags()) {
            tagsArray.add(tag);
        }
        root.set("tags", (JsonNode)tagsArray);
    }

    private void addOptionalFields(SourcingCriterionInfo annotation, ObjectNode root) {
        if (!annotation.label().isEmpty()) {
            root.put("label", annotation.label());
        }
        if (!annotation.description().isEmpty()) {
            root.put("description", annotation.description());
        }
    }

    private void addParams(ObjectNode root, ObjectMapper mapper) {
        ArrayNode paramsArray = mapper.createArrayNode();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(SourcingCriterionParam.class)) continue;
            SourcingCriterionParam param = field.getAnnotation(SourcingCriterionParam.class);
            ObjectNode paramNode = mapper.createObjectNode();
            paramNode.put("name", param.name());
            paramNode.put("component", param.component());
            paramNode.put("mandatory", param.mandatory());
            if (param.exactSearch()) {
                paramNode.put("exactSearch", true);
            }
            if (param.type() != null && !param.type().isEmpty()) {
                paramNode.put("type", param.type());
            }
            if (param.selectComponentOptions().length > 0) {
                paramNode.set("options", (JsonNode)this.buildSelectOptions(param.selectComponentOptions(), mapper));
            }
            paramsArray.add((JsonNode)paramNode);
        }
        root.set("params", (JsonNode)paramsArray);
    }

    private ArrayNode buildSelectOptions(SourcingCriterionParamSelectComponentOption[] selectOptions, ObjectMapper mapper) {
        ArrayNode optionsArray = mapper.createArrayNode();
        for (SourcingCriterionParamSelectComponentOption option : selectOptions) {
            ObjectNode optionNode = mapper.createObjectNode();
            optionNode.put("label", option.label());
            optionNode.put("value", option.value());
            optionsArray.add((JsonNode)optionNode);
        }
        return optionsArray;
    }
}

