/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.context.loader;

import com.apollographql.apollo.api.Query;
import com.fluentcommerce.graphql.sourcing.queries.fulfilmentoptions.GetFulfilmentOptionByIdQuery;
import com.fluentcommerce.graphql.sourcing.queries.product.GetProductsByRefQuery;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.sourcing.LocationUtils;
import com.fluentcommerce.util.sourcing.context.DefaultSourcingContext;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.context.SourcingContextUtils;
import com.fluentcommerce.util.sourcing.context.UnfulfilledItemProcessor;
import com.fluentcommerce.util.sourcing.context.loader.AbstractSourcingContextLoader;
import com.fluentcommerce.util.sourcing.context.model.Address;
import com.fluentcommerce.util.sourcing.context.model.FulfilmentChoice;
import com.fluentcommerce.util.sourcing.context.model.Location;
import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentcommerce.util.sourcing.context.model.Product;
import com.fluentretail.api.model.sku.Price;
import com.fluentretail.rubix.v2.context.Context;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FulfilmentOptionsLoader
extends AbstractSourcingContextLoader<GetFulfilmentOptionByIdQuery.Data> {
    @Override
    protected GetFulfilmentOptionByIdQuery.Data loadResponse(Context context) {
        return (GetFulfilmentOptionByIdQuery.Data)context.api().query((Query)GetFulfilmentOptionByIdQuery.builder().id(context.getEvent().getEntityId()).build());
    }

    @Override
    protected SourcingContext mapResponse(GetFulfilmentOptionByIdQuery.Data fulfilmentOptionResponse, Context context, UnfulfilledItemProcessor unfulfilledItemProcessor) {
        SourcingContext sourcingContext = this.map(fulfilmentOptionResponse.fulfilmentOption(), context);
        return Optional.ofNullable(sourcingContext).map(SourcingContext::toBuilder).map(builder -> builder.unfulfilledItems(unfulfilledItemProcessor.process(sourcingContext)).build()).orElse(null);
    }

    private SourcingContext map(GetFulfilmentOptionByIdQuery.FulfilmentOption fulfilmentOption, Context context) {
        if (fulfilmentOption == null) {
            return DefaultSourcingContext.builder().build();
        }
        Location pickupLocation = LocationUtils.getLocationByRef(context, Optional.of(fulfilmentOption).map(GetFulfilmentOptionByIdQuery.FulfilmentOption::locationRef).orElse(null));
        Map productQuantities = Optional.ofNullable(fulfilmentOption.products()).map(p -> p.stream().collect(Collectors.toMap(product -> Pair.of((Object)product.productRef(), (Object)product.catalogueRef()), GetFulfilmentOptionByIdQuery.Product::requestedQuantity))).orElse(Collections.emptyMap());
        List products = Optional.ofNullable(fulfilmentOption.products()).map(p -> p.stream().map(GetFulfilmentOptionByIdQuery.Product::productRef).collect(Collectors.toList())).map(productRefs -> (GetProductsByRefQuery.Data)context.api().query((Query)GetProductsByRefQuery.builder().productRefs((List<String>)productRefs).build())).map(GetProductsByRefQuery.Data::products).map(this::mapProducts).orElse(null);
        return ((DefaultSourcingContext.DefaultSourcingContextBuilder)((DefaultSourcingContext.DefaultSourcingContextBuilder)DefaultSourcingContext.builder().createdOn((Date)fulfilmentOption.createdOn()).updatedOn((Date)fulfilmentOption.updatedOn()).attributes((List)SourcingContextUtils.mapAttributes(fulfilmentOption.attributes()))).type(fulfilmentOption.orderType()).fulfilmentChoice(FulfilmentChoice.builder().pickupLocationRef(fulfilmentOption.locationRef()).pickupLocation(pickupLocation).address((Address)ObjectUtils.firstNonNull((Object[])new Address[]{Optional.ofNullable(pickupLocation).map(Location::getPrimaryAddress).orElse(null), Optional.ofNullable(fulfilmentOption.address()).map(address -> Address.builder().city(address.city()).companyName(address.companyName()).country(address.country()).name(address.name()).state(address.state()).postcode(address.postcode()).longitude(address.longitude()).latitude(address.latitude()).street(address.addressLine1()).street2(address.addressLine2()).build()).orElse(null)})).build()).items((List)Optional.ofNullable(products).map(p -> p.stream().filter(product -> productQuantities.containsKey(Pair.of((Object)product.getRef(), (Object)product.getCatalogueRef()))).map(product -> OrderItem.builder().product((Product)product).quantity((Integer)productQuantities.get(Pair.of((Object)product.getRef(), (Object)product.getCatalogueRef()))).build()).collect(Collectors.toList())).orElse(null))).build();
    }

    private List<Product> mapProducts(GetProductsByRefQuery.Products products) {
        if (products == null || products.edges() == null || products.edges().isEmpty()) {
            return null;
        }
        return products.edges().stream().map(GetProductsByRefQuery.Edge::node).map(product -> Product.builder().id(product.id()).createdOn((Date)product.createdOn()).updatedOn((Date)product.updatedOn()).ref(product.ref()).type(product.type()).status(product.status()).name(product.name()).summary(product.summary()).attributes(SourcingContextUtils.mapAttributes(product.attributes())).prices(Optional.ofNullable(product.prices()).map(prices -> prices.stream().map(price -> (Price)JsonUtils.anyToPojo((Object)price, Price.class)).collect(Collectors.toList())).orElse(null)).tax(Optional.ofNullable(product.tax()).map(tax -> (Product.Tax)JsonUtils.anyToPojo((Object)tax, Product.Tax.class)).orElse(null)).categories(this.mapCategories(product.categories())).catalogueRef(product.catalogue().ref()).build()).collect(Collectors.toList());
    }

    private List<Product.Category> mapCategories(GetProductsByRefQuery.Categories categories) {
        if (categories == null || categories.categoryEdges() == null || categories.categoryEdges().isEmpty()) {
            return null;
        }
        return categories.categoryEdges().stream().map(GetProductsByRefQuery.CategoryEdge::categoryNode).map(categoryNode -> (Product.Category)JsonUtils.anyToPojo((Object)categoryNode, Product.Category.class)).collect(Collectors.toList());
    }
}

