/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.context.loader;

import com.apollographql.apollo.api.Query;
import com.fluentcommerce.graphql.sourcing.queries.order.GetOrderForSourcingQuery;
import com.fluentcommerce.util.sourcing.LocationUtils;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.context.UnfulfilledItemProcessor;
import com.fluentcommerce.util.sourcing.context.loader.OrderContextLoader;
import com.fluentcommerce.util.sourcing.context.model.Address;
import com.fluentcommerce.util.sourcing.context.model.FulfilmentChoice;
import com.fluentcommerce.util.sourcing.context.model.Location;
import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.v2.context.Context;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class FulfilmentChoiceLoader
extends OrderContextLoader {
    @Override
    protected GetOrderForSourcingQuery.Data loadResponse(Context context) {
        Event event = context.getEvent();
        return (GetOrderForSourcingQuery.Data)context.api().query((Query)GetOrderForSourcingQuery.builder().id(event.getRootEntityId()).fulfilmentChoiceRef(Collections.singletonList(event.getEntityRef())).build());
    }

    @Override
    protected SourcingContext mapResponse(GetOrderForSourcingQuery.Data orderResponse, Context context, UnfulfilledItemProcessor unfulfilledItemProcessor) {
        SourcingContext sourcingContext = this.map(orderResponse.order(), context);
        Location pickupLocation = LocationUtils.getLocationByRef(context, Optional.ofNullable(sourcingContext).map(SourcingContext::getFulfilmentChoice).map(FulfilmentChoice::getPickupLocationRef).orElse(null));
        return Optional.ofNullable(sourcingContext).map(SourcingContext::toBuilder).map(builder -> builder.totalPrice(sourcingContext.getItems() == null ? sourcingContext.getTotalPrice() : Double.valueOf(sourcingContext.getItems().stream().filter(orderItem -> Objects.nonNull(orderItem.getTotalPrice())).mapToDouble(OrderItem::getTotalPrice).sum())).totalTaxPrice(sourcingContext.getItems() == null ? sourcingContext.getTotalTaxPrice() : Double.valueOf(sourcingContext.getItems().stream().filter(orderItem -> Objects.nonNull(orderItem.getTotalTaxPrice())).mapToDouble(OrderItem::getTotalTaxPrice).sum())).fulfilmentChoice(Optional.ofNullable(sourcingContext.getFulfilmentChoice()).map(FulfilmentChoice::toBuilder).map(fulfilmentChoiceBuilder -> fulfilmentChoiceBuilder.pickupLocation(pickupLocation).address(Objects.equals(sourcingContext.getFulfilmentChoice().getType(), "HD") ? (Address)Optional.ofNullable(sourcingContext.getFulfilmentChoice()).map(FulfilmentChoice::getDeliveryAddress).orElse(null) : Optional.ofNullable(pickupLocation).map(Location::getPrimaryAddress).orElseGet(() -> Optional.ofNullable(sourcingContext.getFulfilmentChoice()).map(FulfilmentChoice::getDeliveryAddress).orElse(null))).build()).orElse(null)).fulfilments(Optional.ofNullable(sourcingContext.getFulfilments()).map(fulfilments -> fulfilments.stream().filter(fulfilment -> Objects.equals(fulfilment.getFulfilmentChoiceRef(), Optional.ofNullable(sourcingContext.getFulfilmentChoice()).map(FulfilmentChoice::getRef).orElse(null))).collect(Collectors.toList())).orElse(null)).unfulfilledItems(unfulfilledItemProcessor.process(sourcingContext)).build()).orElse(null);
    }
}

