/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.context;

import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.context.UnfulfilledItemProcessor;
import com.fluentcommerce.util.sourcing.context.loader.FulfilmentChoiceLoader;
import com.fluentcommerce.util.sourcing.context.loader.FulfilmentOptionsLoader;
import com.fluentcommerce.util.sourcing.context.loader.OrderContextLoader;
import com.fluentcommerce.util.sourcing.context.loader.SourcingContextLoader;
import com.fluentretail.api.model.attribute.Attribute;
import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.v2.context.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class SourcingContextUtils {
    private static final Map<String, SourcingContextLoader> DEFAULT_LOADERS = new HashMap<String, SourcingContextLoader>();
    private static final Map<String, SourcingContextLoader> loaderRegistry;

    public static void registerContextLoader(String entityType, SourcingContextLoader loader) {
        loaderRegistry.put(entityType.toLowerCase(Locale.getDefault()), loader);
    }

    public static SourcingContext loadSourcingContext(Context context, UnfulfilledItemProcessor unfulfilledItemProcessor) {
        Event event = context.getEvent();
        String key = event.getEntityType().toLowerCase(Locale.getDefault());
        SourcingContextLoader loader = loaderRegistry.get(key);
        if (loader != null) {
            return loader.load(context, unfulfilledItemProcessor);
        }
        return null;
    }

    public static SourcingContext from(SourcingContext other, UnfulfilledItemProcessor unfulfilledItemProcessor) {
        return other.toBuilder().unfulfilledItems(unfulfilledItemProcessor.process(other)).build();
    }

    public static List<Attribute> mapAttributes(Object rawAttributes) {
        return Optional.ofNullable(rawAttributes).map(obj -> {
            Iterable iterable = (Iterable)obj;
            return StreamSupport.stream(iterable.spliterator(), false).map(SourcingContextUtils::mapToAttribute).collect(Collectors.toList());
        }).orElse(null);
    }

    private static Attribute mapToAttribute(Object source) {
        return (Attribute)JsonUtils.anyToPojo((Object)source, Attribute.class);
    }

    private SourcingContextUtils() {
    }

    static {
        DEFAULT_LOADERS.put("ORDER".toLowerCase(Locale.getDefault()), new OrderContextLoader());
        DEFAULT_LOADERS.put("FULFILMENT_CHOICE".toLowerCase(Locale.getDefault()), new FulfilmentChoiceLoader());
        DEFAULT_LOADERS.put("FULFILMENT_OPTIONS".toLowerCase(Locale.getDefault()), new FulfilmentOptionsLoader());
        loaderRegistry = new ConcurrentHashMap<String, SourcingContextLoader>(DEFAULT_LOADERS);
    }
}

