/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.condition.operator;

import com.fluentcommerce.util.sourcing.condition.operator.SourcingConditionBetweenOperator;
import com.fluentcommerce.util.sourcing.condition.operator.SourcingConditionExistsOperator;
import com.fluentcommerce.util.sourcing.condition.operator.SourcingConditionMathOperator;
import com.fluentcommerce.util.sourcing.condition.operator.SourcingConditionMembershipOperator;
import com.fluentcommerce.util.sourcing.condition.operator.SourcingConditionOperator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class SourcingConditionOperatorRegistry {
    private static final Map<String, SourcingConditionOperator> typeToOperatorMap = new ConcurrentHashMap<String, SourcingConditionOperator>();

    private SourcingConditionOperatorRegistry() {
    }

    public static SourcingConditionOperator getSourcingConditionOperator(String operatorName) {
        Objects.requireNonNull(operatorName, "Operator name must not be null");
        SourcingConditionOperator operator = typeToOperatorMap.get(operatorName);
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Unknown operator name: %s", operatorName));
        }
        return operator;
    }

    public static void register(String operatorName, SourcingConditionOperator operator) {
        typeToOperatorMap.put(operatorName, operator);
    }

    static {
        typeToOperatorMap.put("equals", SourcingConditionMathOperator::ifValueEquals);
        typeToOperatorMap.put("not_equals", SourcingConditionMathOperator::ifValueNotEquals);
        typeToOperatorMap.put("greater_than", SourcingConditionMathOperator::ifValueIsGreaterThan);
        typeToOperatorMap.put("greater_than_or_equals", SourcingConditionMathOperator::ifValueIsGreaterThanOrEquals);
        typeToOperatorMap.put("less_than", SourcingConditionMathOperator::ifValueIsLessThan);
        typeToOperatorMap.put("less_than_or_equals", SourcingConditionMathOperator::ifValueIsLessThanOrEquals);
        typeToOperatorMap.put("in", SourcingConditionMembershipOperator::ifValueIn);
        typeToOperatorMap.put("not_in", SourcingConditionMembershipOperator::ifValueNotIn);
        typeToOperatorMap.put("between", SourcingConditionBetweenOperator::ifValueBetween);
        typeToOperatorMap.put("exists", SourcingConditionExistsOperator::ifExists);
    }
}

