/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.condition.operator;

import com.fluentcommerce.util.sourcing.condition.operator.AbstractSourcingConditionOperator;
import java.util.function.Predicate;

public class SourcingConditionMathOperator
extends AbstractSourcingConditionOperator {
    private final Predicate<Integer> predicate;

    public SourcingConditionMathOperator(Predicate<Integer> predicate) {
        this.predicate = predicate;
    }

    @Override
    protected boolean doEvaluate(Object ... operands) {
        Object contextValue = this.getContextValue(operands);
        if (contextValue == null) {
            return false;
        }
        Object value = this.convertValue(operands[1], this.getContextValueType(operands));
        if (value == null) {
            return false;
        }
        return this.predicate.test(this.toComparable(contextValue).compareTo(this.toComparable(value)));
    }

    @Override
    protected boolean validateOperands(Object[] operands) {
        if (operands.length != 2) {
            return false;
        }
        Class<?> valueType = this.getContextValueType(operands);
        return valueType == null || Comparable.class.isAssignableFrom(valueType);
    }

    public static boolean ifValueEquals(Object ... operands) {
        return new SourcingConditionMathOperator(compareResult -> compareResult == 0).evaluate(operands[0], operands[1]);
    }

    public static boolean ifValueNotEquals(Object ... operands) {
        return new SourcingConditionMathOperator(compareResult -> compareResult != 0).evaluate(operands[0], operands[1]);
    }

    public static boolean ifValueIsGreaterThan(Object ... operands) {
        return new SourcingConditionMathOperator(compareResult -> compareResult > 0).evaluate(operands[0], operands[1]);
    }

    public static boolean ifValueIsGreaterThanOrEquals(Object ... operands) {
        return new SourcingConditionMathOperator(compareResult -> compareResult >= 0).evaluate(operands[0], operands[1]);
    }

    public static boolean ifValueIsLessThan(Object ... operands) {
        return new SourcingConditionMathOperator(compareResult -> compareResult < 0).evaluate(operands[0], operands[1]);
    }

    public static boolean ifValueIsLessThanOrEquals(Object ... operands) {
        return new SourcingConditionMathOperator(a -> a <= 0).evaluate(operands[0], operands[1]);
    }
}

