/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.condition.operator;

import com.fluentcommerce.util.sourcing.condition.operator.AbstractSourcingConditionOperator;
import java.util.Map;

public class SourcingConditionBetweenOperator
extends AbstractSourcingConditionOperator {
    @Override
    protected boolean doEvaluate(Object ... operands) {
        Object contextValue = this.getContextValue(operands);
        if (contextValue == null || operands[1] == null) {
            return false;
        }
        Map value = (Map)operands[1];
        Object from = this.convertValue(value.get("from"), this.getContextValueType(operands));
        Object to = this.convertValue(value.get("to"), this.getContextValueType(operands));
        if (from == null && to == null) {
            return false;
        }
        boolean lowerCheck = from == null || this.toComparable(contextValue).compareTo(this.toComparable(from)) >= 0;
        boolean upperCheck = to == null || this.toComparable(contextValue).compareTo(this.toComparable(to)) <= 0;
        return lowerCheck && upperCheck;
    }

    @Override
    protected boolean validateOperands(Object ... operands) {
        if (operands.length != 2) {
            return false;
        }
        if (operands[1] != null && !(operands[1] instanceof Map)) {
            return false;
        }
        Class<?> valueType = this.getContextValueType(operands);
        return valueType == null || Comparable.class.isAssignableFrom(valueType);
    }

    public static boolean ifValueBetween(Object ... operands) {
        return new SourcingConditionBetweenOperator().evaluate(operands[0], operands[1]);
    }
}

