/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.condition.operator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fluentcommerce.util.sourcing.condition.operator.SourcingConditionOperator;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public abstract class AbstractSourcingConditionOperator
implements SourcingConditionOperator {
    protected static final int BINARY_OPERATOR_OPERAND_COUNT = 2;
    protected static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public boolean evaluate(Object ... operands) {
        if (!this.validateOperands(operands)) {
            throw new IllegalArgumentException("Invalid operands provided.");
        }
        return this.doEvaluate(operands);
    }

    protected Object getContextValue(Object ... operands) {
        return operands[0];
    }

    protected Class<?> getContextValueType(Object ... operands) {
        Object value = this.getContextValue(operands);
        return value == null ? null : value.getClass();
    }

    protected <T extends Comparable<?>> T toComparable(Object operand) {
        return (T)((Comparable)operand);
    }

    protected abstract boolean doEvaluate(Object ... var1);

    protected abstract boolean validateOperands(Object ... var1);

    protected Object convertValue(Object value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (Long.class == type) {
            try {
                Instant instant = Instant.parse((CharSequence)mapper.convertValue(value, String.class));
                return instant.toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return mapper.convertValue(value, type);
    }
}

