/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.condition;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.sourcing.condition.SourcingCondition;
import com.fluentcommerce.util.sourcing.condition.SourcingConditionTypeRegistry;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.profile.SourcingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public final class SourcingConditionUtils {
    private SourcingConditionUtils() {
    }

    public static boolean evaluateSourcingConditions(SourcingContext sourcingContext, List<SourcingStrategy.SourcingStrategyCondition> conditions) {
        Objects.requireNonNull(sourcingContext, "sourcing context cannot be null");
        if (CollectionUtils.isEmpty(conditions)) {
            return true;
        }
        ArrayList<SourcingCondition> sourcingConditionList = new ArrayList<SourcingCondition>();
        ObjectNode sourcingContextJson = JsonUtils.objectToNode((Object)sourcingContext);
        for (SourcingStrategy.SourcingStrategyCondition condition : conditions) {
            Class<? extends SourcingCondition> sourcingConditionType = SourcingConditionTypeRegistry.getSourcingConditionType(condition.getType());
            SourcingCondition sourcingCondition = (SourcingCondition)JsonUtils.anyToPojo((Object)condition.getParams(), sourcingConditionType);
            sourcingConditionList.add(sourcingCondition);
        }
        return sourcingConditionList.stream().allMatch(arg_0 -> SourcingConditionUtils.lambda$evaluateSourcingConditions$0((JsonNode)sourcingContextJson, arg_0));
    }

    private static /* synthetic */ boolean lambda$evaluateSourcingConditions$0(JsonNode sourcingContextJson, SourcingCondition sourcingCondition) {
        return sourcingCondition.evaluateWithContext(sourcingContextJson);
    }
}

