/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing.condition;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.sourcing.condition.SourcingCondition;
import com.fluentcommerce.util.sourcing.condition.SourcingConditionConstants;
import com.fluentcommerce.util.sourcing.condition.operator.SourcingConditionOperator;
import com.fluentcommerce.util.sourcing.condition.operator.SourcingConditionOperatorRegistry;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DefaultSourcingCondition
implements SourcingCondition {
    protected static final ObjectMapper mapper = new ObjectMapper();
    @JsonProperty
    protected String path;
    @JsonProperty
    protected String operator;
    @JsonProperty
    protected SourcingConditionConstants.SourcingConditionScope conditionScope;
    @JsonProperty
    protected Object value;

    @Override
    public boolean evaluateWithContext(JsonNode sourcingContext) {
        JsonNode contextNode = JsonUtils.getPath((JsonNode)sourcingContext, (String)this.path);
        if (contextNode.isArray()) {
            return this.doEvaluate(this.flatten(contextNode));
        }
        return this.doEvaluate(contextNode);
    }

    protected boolean doEvaluate(Stream<JsonNode> contextNodeStream) {
        if (this.conditionScope == null) {
            throw new IllegalArgumentException("Condition scope can not be null");
        }
        switch (this.conditionScope) {
            case ALL: {
                return contextNodeStream.allMatch(this::doEvaluate);
            }
            case ANY: {
                return contextNodeStream.anyMatch(this::doEvaluate);
            }
            case NONE: {
                return contextNodeStream.noneMatch(this::doEvaluate);
            }
        }
        throw new IllegalStateException("Unexpected condition scope: " + (Object)((Object)this.conditionScope));
    }

    protected boolean doEvaluate(JsonNode contextNode) {
        return this.getSourcingConditionOperator().evaluate(this.getContextNodeValue(contextNode), this.value);
    }

    protected Object getContextNodeValue(JsonNode contextNode) {
        if (!contextNode.isValueNode()) {
            throw new IllegalArgumentException("Context node must be a value node");
        }
        return mapper.convertValue((Object)contextNode, Object.class);
    }

    protected SourcingConditionOperator getSourcingConditionOperator() {
        return SourcingConditionOperatorRegistry.getSourcingConditionOperator(this.operator);
    }

    protected Stream<JsonNode> flatten(JsonNode node) {
        if (node.isArray()) {
            return StreamSupport.stream(node.spliterator(), false).flatMap(this::flatten);
        }
        return Stream.of(node);
    }
}

