/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing;

import com.apollographql.apollo.api.Query;
import com.fluentcommerce.graphql.sourcing.queries.inventory.GetVirtualPositionsQuery;
import com.fluentcommerce.graphql.sourcing.queries.profile.GetProfileByRefQuery;
import com.fluentcommerce.graphql.type.VirtualCatalogueKey;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.sourcing.LocationUtils;
import com.fluentcommerce.util.sourcing.OrderUtils;
import com.fluentcommerce.util.sourcing.condition.SourcingConditionUtils;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.context.model.Fulfilment;
import com.fluentcommerce.util.sourcing.context.model.Location;
import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentcommerce.util.sourcing.criterion.SourcingCriteriaUtils;
import com.fluentcommerce.util.sourcing.inventory.InventoryProcessor;
import com.fluentcommerce.util.sourcing.inventory.VirtualPosition;
import com.fluentcommerce.util.sourcing.profile.Network;
import com.fluentcommerce.util.sourcing.profile.SourcingProfile;
import com.fluentcommerce.util.sourcing.profile.SourcingStrategy;
import com.fluentcommerce.util.sourcing.profile.VirtualCatalogue;
import com.fluentretail.rubix.v2.context.Context;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class SourcingUtils {
    private static final VirtualPosition NO_STOCK = VirtualPosition.builder().ref("NO_STOCK").status("INACTIVE").quantity(0).build();
    private static final int MAX_POSITIONS = 5000;
    public static final ImmutableList<LocationAndPositions> NONE = ImmutableList.of();

    public static SourcingProfile loadSourcingProfile(Context context) {
        GetProfileByRefQuery.Data profileResponse = (GetProfileByRefQuery.Data)context.api().query((Query)GetProfileByRefQuery.builder().profileRef(context.getProp("sourcingProfileRef")).build());
        return (SourcingProfile)JsonUtils.anyToPojo((Object)profileResponse.sourcingProfile(), SourcingProfile.class);
    }

    public static List<LocationAndPositions> loadPositions(Context context, SourcingContext sourcingContext, SourcingCriteriaUtils.CriteriaArray sourcingCriteria, String catalogueRef, List<Location> locations, List<String> positionStatuses, InventoryProcessor inventoryProcessor) {
        List<OrderItem> items = sourcingContext.getUnfulfilledItems();
        if (items.isEmpty()) {
            return ImmutableList.of();
        }
        List locationsWithoutStock = locations.stream().map(location -> new LocationAndPositions((Location)location, null, sourcingCriteria.apply(SourcingCriteriaUtils.DefaultCriterionContext.builder().sourcingContext(sourcingContext).lap(new LocationAndPositions((Location)location, null, null)).build()))).filter(LocationAndPositions::isValid).collect(Collectors.toList());
        sourcingCriteria.normalize(locationsWithoutStock.stream().map(LocationAndPositions::getRating).collect(Collectors.toList()));
        locationsWithoutStock = locationsWithoutStock.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        int locationLimit = 5000 / items.size();
        GetVirtualPositionsQuery.Data positions = (GetVirtualPositionsQuery.Data)context.api().query((Query)GetVirtualPositionsQuery.builder().catalogues(Collections.singletonList(VirtualCatalogueKey.builder().ref(catalogueRef).build())).products(items.stream().map(i -> i.getProduct().getRef()).distinct().collect(Collectors.toList())).groups(locationsWithoutStock.stream().limit(locationLimit).map(lap -> lap.getLocation().getRef()).collect(Collectors.toList())).first(5000).status(positionStatuses).build());
        List<VirtualPosition> virtualPositions = JsonUtils.stream(positions.virtualPositions().edges()).map(GetVirtualPositionsQuery.Edge::node).map(node -> (VirtualPosition)JsonUtils.anyToPojo((Object)node, VirtualPosition.class)).collect(Collectors.toList());
        if (inventoryProcessor != null) {
            virtualPositions = inventoryProcessor.process(sourcingContext, virtualPositions);
        }
        Map<String, Map<String, VirtualPosition>> collected = virtualPositions.stream().collect(Collectors.groupingBy(VirtualPosition::getGroupRef, Collectors.mapping(node -> node, Collectors.toMap(VirtualPosition::getProductRef, n -> n))));
        locationsWithoutStock = locationsWithoutStock.stream().map(lap -> new LocationAndPositions(lap.getLocation(), items.stream().mapToInt(i -> ((Map)collected.getOrDefault(lap.getLocation().getRef(), (Map<String, VirtualPosition>)ImmutableMap.of())).getOrDefault(i.getProduct().getRef(), NO_STOCK).getQuantity()).toArray(), lap.getRating())).map(lap -> new LocationAndPositions(lap.getLocation(), lap.getQuantities(), sourcingCriteria.apply(SourcingCriteriaUtils.DefaultCriterionContext.builder().sourcingContext(sourcingContext).lap((LocationAndPositions)lap).build()))).filter(LocationAndPositions::isValid).collect(Collectors.toList());
        sourcingCriteria.normalize(locationsWithoutStock.stream().map(LocationAndPositions::getRating).collect(Collectors.toList()));
        return (List)locationsWithoutStock.stream().sorted(Comparator.reverseOrder()).limit(locationLimit).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    public static Set<String> getLocationRefs(List<Fulfilment> fulfilments) {
        return fulfilments.stream().map(f -> f.getLocation().getRef()).collect(Collectors.toSet());
    }

    public static Optional<Fulfilment> findHighestValuePartialFulfilment(List<LocationAndPositions> locationsAndPositions, List<OrderItem> remainingItems, Set<String> excludedLocations) {
        List filteredLaps = locationsAndPositions.stream().filter(lap -> !excludedLocations.contains(lap.getLocation().getRef())).collect(Collectors.toList());
        List values = filteredLaps.stream().map(LocationAndPositions::getRating).collect(Collectors.toList());
        float[] bestResult = new float[values.isEmpty() ? 1 : ((float[])values.get(0)).length];
        int bestIndex = -1;
        for (int i = 0; i < values.size(); ++i) {
            if (SourcingUtils.arrayCompare((float[])values.get(i), bestResult) <= 0 || !SourcingUtils.canFulfill((LocationAndPositions)filteredLaps.get(i), remainingItems)) continue;
            bestIndex = i;
            bestResult = (float[])values.get(i);
        }
        return bestIndex >= 0 ? Optional.of(SourcingUtils.buildPlan((List<LocationAndPositions>)ImmutableList.of(filteredLaps.get(bestIndex)), remainingItems).getFulfilments().get(0)) : Optional.empty();
    }

    private static boolean canFulfill(LocationAndPositions lap, List<OrderItem> remainingItems) {
        for (int i = 0; i < lap.getQuantities().length; ++i) {
            if (lap.getQuantities()[i] <= 0 || remainingItems.get(i).getQuantity() <= 0) continue;
            return true;
        }
        return false;
    }

    public static SourcingPlan findPlanForAllItems(Context context, String catalogueRef, SourcingContext sourcingContext, List<Location> locations, SourcingCriteriaUtils.CriteriaArray sourcingCriteria, int maxSplit, List<String> positionStatuses, InventoryProcessor inventoryProcessor) {
        List<OrderItem> items = sourcingContext.getUnfulfilledItems();
        if (items == null) {
            return SourcingUtils.buildPlan(new ArrayList<LocationAndPositions>(), new ArrayList<OrderItem>());
        }
        if (items.isEmpty()) {
            return SourcingUtils.buildPlan(new ArrayList<LocationAndPositions>(), items);
        }
        int[] quantities = items.stream().mapToInt(OrderItem::getQuantity).toArray();
        List<LocationAndPositions> laps = SourcingUtils.loadPositions(context, sourcingContext, sourcingCriteria, catalogueRef, locations, positionStatuses, inventoryProcessor);
        ImmutableList<LocationAndPositions> bestCombo = SourcingUtils.searchPermutationsForAllMatchPlan(laps, maxSplit, quantities);
        return SourcingUtils.buildPlan(bestCombo, items);
    }

    public static ImmutableList<LocationAndPositions> searchPermutationsForAllMatchPlan(List<LocationAndPositions> locations, int maxSplit, int ... quantities) {
        Stack<Integer> currentPlan = new Stack<Integer>();
        Stack<int[]> remainingQuantities = new Stack<int[]>();
        for (int fulfilmentLimit = 1; fulfilmentLimit <= maxSplit + 1; ++fulfilmentLimit) {
            currentPlan.clear();
            remainingQuantities.clear();
            remainingQuantities.add(quantities);
            int loc = 0;
            while (loc < locations.size()) {
                currentPlan.push(loc);
                int[] newRemaining = SourcingUtils.arraySubtract((int[])remainingQuantities.peek(), locations.get(loc).quantities);
                remainingQuantities.push(newRemaining);
                if (currentPlan.size() < fulfilmentLimit) {
                    ++loc;
                    continue;
                }
                if (SourcingUtils.quantityIsComplete(newRemaining)) {
                    return currentPlan.stream().map(locations::get).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
                }
                while (currentPlan.size() == fulfilmentLimit || !currentPlan.isEmpty() && loc + (fulfilmentLimit - currentPlan.size()) >= locations.size()) {
                    loc = (Integer)currentPlan.pop();
                    remainingQuantities.pop();
                }
                ++loc;
            }
        }
        return NONE;
    }

    private static SourcingPlan buildPlan(List<LocationAndPositions> laps, List<OrderItem> items) {
        int[] quantities = items.stream().mapToInt(OrderItem::getQuantity).toArray();
        ImmutableList.Builder fulfilmentBuilder = ImmutableList.builder();
        for (LocationAndPositions lap : laps) {
            ImmutableList.Builder itemBuilder = ImmutableList.builder();
            for (int i = 0; i < items.size(); ++i) {
                if (lap.getQuantities()[i] <= 0 || quantities[i] <= 0) continue;
                OrderItem orderItem = items.get(i);
                itemBuilder.add((Object)Fulfilment.FulfilmentItem.builder().orderItem(orderItem).requestedQuantity(Math.min(lap.getQuantities()[i], quantities[i])).build());
            }
            fulfilmentBuilder.add((Object)Fulfilment.builder().location(lap.getLocation()).items((List<Fulfilment.FulfilmentItem>)itemBuilder.build()).build());
            quantities = SourcingUtils.arraySubtract(quantities, lap.quantities);
        }
        return new SourcingPlan(SourcingUtils.quantityIsComplete(quantities), (List<Fulfilment>)fulfilmentBuilder.build());
    }

    private static int[] arraySubtract(int[] a, int ... b) {
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] - b[i];
        }
        return result;
    }

    private static int arrayCompare(float[] a, float ... b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < b[i]) {
                return -1;
            }
            if (!(a[i] > b[i])) continue;
            return 1;
        }
        return 0;
    }

    private static boolean quantityIsComplete(int ... remainingItems) {
        for (int remainingItem : remainingItems) {
            if (remainingItem <= 0) continue;
            return false;
        }
        return true;
    }

    public static List<OrderItem> getUnfulfilledItems(SourcingContext sourcingContext) {
        if (sourcingContext == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder fulfilmentItemsBuilder = ImmutableList.builder();
        if (sourcingContext.getFulfilments() != null) {
            for (com.fluentcommerce.util.sourcing.context.model.Fulfilment fulfilment : sourcingContext.getFulfilments()) {
                if (fulfilment.getItems() == null) continue;
                fulfilmentItemsBuilder.addAll(fulfilment.getItems());
            }
        }
        ImmutableList fulfilmentItems = fulfilmentItemsBuilder.build();
        ImmutableList.Builder unfulfilledItems = ImmutableList.builder();
        if (sourcingContext.getItems() != null) {
            sourcingContext.getItems().stream().forEach(orderItem -> {
                int allocatedQuantity;
                int quantity = orderItem.getQuantity();
                if (quantity > (allocatedQuantity = fulfilmentItems.stream().filter(fItem -> fItem.getOrderItem().getId().equals(orderItem.getId())).mapToInt(fItem -> fItem.getRequestedQuantity() - fItem.getRejectedQuantity()).sum())) {
                    unfulfilledItems.add((Object)orderItem.toBuilder().quantity(quantity - allocatedQuantity).build());
                }
            });
        }
        return unfulfilledItems.build();
    }

    public static SourcingPlan findPlanBasedOnStrategies(Context context, SourcingContext sourcingContext, SourcingProfile profile, List<String> positionStatuses, InventoryProcessor inventoryProcessor) {
        SourcingPlan sourcingPlan = new SourcingPlan();
        for (SourcingStrategy strategy : Objects.requireNonNull(profile.getSourcingStrategies()).stream().filter(sourcingStrategy -> "ACTIVE".equals(sourcingStrategy.getStatus())).filter(sourcingStrategy -> SourcingConditionUtils.evaluateSourcingConditions(sourcingContext, sourcingStrategy.getSourcingConditions())).sorted(Comparator.comparing(SourcingStrategy::getPriority)).collect(Collectors.toList())) {
            String networkRef = SourcingUtils.getNetworkRef(profile, strategy);
            List<Location> allLocations = LocationUtils.getLocationsInNetwork(context, networkRef);
            String virtualCatalogueRef = SourcingUtils.getVirtualCatalogueRef(profile, strategy);
            Integer maxSplit = SourcingUtils.getMaxSplit(profile, strategy);
            SourcingCriteriaUtils.CriteriaArray criteria = SourcingCriteriaUtils.getCriteria(strategy, SourcingCriteriaUtils.getDefaultCriteria());
            SourcingPlan plan = SourcingUtils.findPlanForAllItems(context, virtualCatalogueRef, sourcingContext, allLocations, criteria, maxSplit, positionStatuses, inventoryProcessor);
            if (!plan.isFullySourced()) continue;
            return plan;
        }
        return sourcingPlan;
    }

    public static SourcingPlan findPlanBasedOnFallbackStrategies(Context context, SourcingContext sourcingContext, SourcingProfile profile, List<String> positionStatuses, InventoryProcessor inventoryProcessor) {
        SourcingPlan sourcingPlan = new SourcingPlan();
        Objects.requireNonNull(profile.getSourcingFallbackStrategies()).stream().filter(sourcingStrategy -> "ACTIVE".equals(sourcingStrategy.getStatus())).filter(strategy -> SourcingConditionUtils.evaluateSourcingConditions(sourcingContext, strategy.getSourcingConditions())).sorted(Comparator.comparing(SourcingStrategy::getPriority)).findFirst().ifPresent(fallbackStrategy -> {
            List<OrderItem> remainingItems;
            String networkRef = SourcingUtils.getNetworkRef(profile, fallbackStrategy);
            List<Location> allLocations = LocationUtils.getLocationsInNetwork(context, networkRef);
            String virtualCatalogueRef = SourcingUtils.getVirtualCatalogueRef(profile, fallbackStrategy);
            Integer maxSplit = SourcingUtils.getMaxSplit(profile, fallbackStrategy);
            SourcingCriteriaUtils.CriteriaArray criteria = SourcingCriteriaUtils.getCriteria(fallbackStrategy, SourcingCriteriaUtils.getDefaultCriteria());
            List<LocationAndPositions> laps = SourcingUtils.loadPositions(context, sourcingContext, criteria, virtualCatalogueRef, allLocations, positionStatuses, inventoryProcessor);
            List<OrderItem> items = sourcingContext.getUnfulfilledItems();
            int fulfilmentLimit = maxSplit - sourcingContext.getFulfilments().size() + 1;
            ArrayList<Fulfilment> fulfilments = new ArrayList<Fulfilment>();
            for (int i = 0; i < fulfilmentLimit && (remainingItems = OrderUtils.itemsMinusFulfilments(items, fulfilments)).stream().mapToInt(OrderItem::getQuantity).sum() > 0; ++i) {
                SourcingUtils.findHighestValuePartialFulfilment(laps, remainingItems, SourcingUtils.getLocationRefs(fulfilments)).ifPresent(fulfilments::add);
            }
            if (!fulfilments.isEmpty()) {
                sourcingPlan.setFulfilments(fulfilments);
            }
        });
        return sourcingPlan;
    }

    public static Fulfilment buildRejectedFulfilment(Context context, SourcingContext sourcingContext, String sysRejectedLocationRef) {
        List<OrderItem> unfulfilledItems = sourcingContext.getUnfulfilledItems();
        if (unfulfilledItems == null || unfulfilledItems.isEmpty()) {
            return null;
        }
        ImmutableList.Builder fulfilmentItemsBuilder = ImmutableList.builder();
        if (sourcingContext.getFulfilments() != null) {
            sourcingContext.getFulfilments().stream().map(com.fluentcommerce.util.sourcing.context.model.Fulfilment::getItems).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)fulfilmentItemsBuilder).addAll(arg_0));
        }
        Location rejectLocation = LocationUtils.getLocationByRef(context, sysRejectedLocationRef);
        ArrayList<Fulfilment.FulfilmentItem> items = new ArrayList<Fulfilment.FulfilmentItem>(unfulfilledItems.size());
        unfulfilledItems.forEach(item -> {
            int quantity = item.getQuantity();
            items.add(Fulfilment.FulfilmentItem.builder().orderItem((OrderItem)item).requestedQuantity(quantity).rejectedQuantity(quantity).build());
        });
        return Fulfilment.builder().location(rejectLocation).items(items).build();
    }

    public static String getVirtualCatalogueRef(SourcingProfile profile, SourcingStrategy strategy) {
        String virtualCatalogueRef = Optional.ofNullable(strategy.getVirtualCatalogue()).map(VirtualCatalogue::getRef).orElse(null);
        String defaultVirtualCatalogueRef = Optional.ofNullable(profile.getDefaultVirtualCatalogue()).map(VirtualCatalogue::getRef).orElse(null);
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{virtualCatalogueRef, defaultVirtualCatalogueRef});
    }

    public static String getNetworkRef(SourcingProfile profile, SourcingStrategy strategy) {
        String networkRef = Optional.ofNullable(strategy.getNetwork()).map(Network::getRef).orElse(null);
        String defaultNetworkRef = Optional.ofNullable(profile.getDefaultNetwork()).map(Network::getRef).orElse(null);
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{networkRef, defaultNetworkRef});
    }

    public static Integer getMaxSplit(SourcingProfile profile, SourcingStrategy strategy) {
        Integer maxSplit = strategy.getMaxSplit();
        return maxSplit != null ? maxSplit : profile.getDefaultMaxSplit();
    }

    private SourcingUtils() {
    }

    public static class Fulfilment {
        Location location;
        List<Fulfilment.FulfilmentItem> items;
        String type;

        Fulfilment(Location location, List<Fulfilment.FulfilmentItem> items, String type) {
            this.location = location;
            this.items = items;
            this.type = type;
        }

        public static FulfilmentBuilder builder() {
            return new FulfilmentBuilder();
        }

        public Location getLocation() {
            return this.location;
        }

        public List<Fulfilment.FulfilmentItem> getItems() {
            return this.items;
        }

        public String getType() {
            return this.type;
        }

        public void setLocation(Location location) {
            this.location = location;
        }

        public void setItems(List<Fulfilment.FulfilmentItem> items) {
            this.items = items;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fulfilment)) {
                return false;
            }
            Fulfilment other = (Fulfilment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Location this$location = this.getLocation();
            Location other$location = other.getLocation();
            if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
                return false;
            }
            List<Fulfilment.FulfilmentItem> this$items = this.getItems();
            List<Fulfilment.FulfilmentItem> other$items = other.getItems();
            if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Fulfilment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Location $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
            List<Fulfilment.FulfilmentItem> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "SourcingUtils.Fulfilment(location=" + this.getLocation() + ", items=" + this.getItems() + ", type=" + this.getType() + ")";
        }

        public static class FulfilmentBuilder {
            private Location location;
            private List<Fulfilment.FulfilmentItem> items;
            private String type;

            FulfilmentBuilder() {
            }

            public FulfilmentBuilder location(Location location) {
                this.location = location;
                return this;
            }

            public FulfilmentBuilder items(List<Fulfilment.FulfilmentItem> items) {
                this.items = items;
                return this;
            }

            public FulfilmentBuilder type(String type) {
                this.type = type;
                return this;
            }

            public Fulfilment build() {
                return new Fulfilment(this.location, this.items, this.type);
            }

            public String toString() {
                return "SourcingUtils.Fulfilment.FulfilmentBuilder(location=" + this.location + ", items=" + this.items + ", type=" + this.type + ")";
            }
        }
    }

    public static class SourcingPlan {
        boolean fullySourced;
        List<Fulfilment> fulfilments;

        public boolean isFullySourced() {
            return this.fullySourced;
        }

        public List<Fulfilment> getFulfilments() {
            return this.fulfilments;
        }

        public void setFullySourced(boolean fullySourced) {
            this.fullySourced = fullySourced;
        }

        public void setFulfilments(List<Fulfilment> fulfilments) {
            this.fulfilments = fulfilments;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourcingPlan)) {
                return false;
            }
            SourcingPlan other = (SourcingPlan)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isFullySourced() != other.isFullySourced()) {
                return false;
            }
            List<Fulfilment> this$fulfilments = this.getFulfilments();
            List<Fulfilment> other$fulfilments = other.getFulfilments();
            return !(this$fulfilments == null ? other$fulfilments != null : !((Object)this$fulfilments).equals(other$fulfilments));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SourcingPlan;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFullySourced() ? 79 : 97);
            List<Fulfilment> $fulfilments = this.getFulfilments();
            result = result * 59 + ($fulfilments == null ? 43 : ((Object)$fulfilments).hashCode());
            return result;
        }

        public String toString() {
            return "SourcingUtils.SourcingPlan(fullySourced=" + this.isFullySourced() + ", fulfilments=" + this.getFulfilments() + ")";
        }

        @ConstructorProperties(value={"fullySourced", "fulfilments"})
        public SourcingPlan(boolean fullySourced, List<Fulfilment> fulfilments) {
            this.fullySourced = fullySourced;
            this.fulfilments = fulfilments;
        }

        public SourcingPlan() {
        }
    }

    public static final class LocationAndPositions
    implements Comparable<LocationAndPositions> {
        private final Location location;
        private final int[] quantities;
        private final float[] rating;

        public boolean isValid() {
            if (this.rating == null) {
                return true;
            }
            for (float c : this.rating) {
                if (!(c < 0.0f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(@NotNull LocationAndPositions o) {
            return SourcingUtils.arrayCompare(this.rating, o.rating);
        }

        public static LocationAndPositionsBuilder builder() {
            return new LocationAndPositionsBuilder();
        }

        public Location getLocation() {
            return this.location;
        }

        public int[] getQuantities() {
            return this.quantities;
        }

        public float[] getRating() {
            return this.rating;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocationAndPositions)) {
                return false;
            }
            LocationAndPositions other = (LocationAndPositions)o;
            Location this$location = this.getLocation();
            Location other$location = other.getLocation();
            if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
                return false;
            }
            if (!Arrays.equals(this.getQuantities(), other.getQuantities())) {
                return false;
            }
            return Arrays.equals(this.getRating(), other.getRating());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Location $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
            result = result * 59 + Arrays.hashCode(this.getQuantities());
            result = result * 59 + Arrays.hashCode(this.getRating());
            return result;
        }

        public String toString() {
            return "SourcingUtils.LocationAndPositions(location=" + this.getLocation() + ", quantities=" + Arrays.toString(this.getQuantities()) + ", rating=" + Arrays.toString(this.getRating()) + ")";
        }

        @ConstructorProperties(value={"location", "quantities", "rating"})
        public LocationAndPositions(Location location, int[] quantities, float[] rating) {
            this.location = location;
            this.quantities = quantities;
            this.rating = rating;
        }

        public static class LocationAndPositionsBuilder {
            private Location location;
            private int[] quantities;
            private float[] rating;

            LocationAndPositionsBuilder() {
            }

            public LocationAndPositionsBuilder location(Location location) {
                this.location = location;
                return this;
            }

            public LocationAndPositionsBuilder quantities(int[] quantities) {
                this.quantities = quantities;
                return this;
            }

            public LocationAndPositionsBuilder rating(float[] rating) {
                this.rating = rating;
                return this;
            }

            public LocationAndPositions build() {
                return new LocationAndPositions(this.location, this.quantities, this.rating);
            }

            public String toString() {
                return "SourcingUtils.LocationAndPositions.LocationAndPositionsBuilder(location=" + this.location + ", quantities=" + Arrays.toString(this.quantities) + ", rating=" + Arrays.toString(this.rating) + ")";
            }
        }
    }
}

