/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing;

import com.apollographql.apollo.api.Mutation;
import com.fluentcommerce.graphql.sourcing.mutation.CreateFulfilmentMutation;
import com.fluentcommerce.graphql.type.AddressId;
import com.fluentcommerce.graphql.type.CreateFulfilmentInput;
import com.fluentcommerce.graphql.type.CreateFulfilmentItemWithFulfilmentInput;
import com.fluentcommerce.graphql.type.OrderId;
import com.fluentcommerce.graphql.type.OrderItemId;
import com.fluentcommerce.types.core.constants.CoreExceptionCode;
import com.fluentcommerce.util.FulfilmentUtils;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.sourcing.SourcingUtils;
import com.fluentcommerce.util.sourcing.context.SourcingContext;
import com.fluentcommerce.util.sourcing.context.model.Fulfilment;
import com.fluentcommerce.util.sourcing.context.model.FulfilmentChoice;
import com.fluentcommerce.util.sourcing.context.model.OrderItem;
import com.fluentretail.rubix.exceptions.RubixException;
import com.fluentretail.rubix.v2.context.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class OrderUtils {
    public static List<OrderItem> itemsMinusFulfilments(List<OrderItem> items, List<SourcingUtils.Fulfilment> fulfilments) {
        Map<String, Integer> fulfilmentsTotals = JsonUtils.stream(fulfilments).flatMap(fulfilment -> fulfilment.getItems().stream()).collect(Collectors.groupingBy(item -> item.getOrderItem().getProduct().getRef(), Collectors.summingInt(Fulfilment.FulfilmentItem::getRequestedQuantity)));
        return items.stream().map(i -> i.toBuilder().quantity(i.getQuantity() - fulfilmentsTotals.getOrDefault(i.getProduct().getRef(), 0)).build()).collect(Collectors.toList());
    }

    public static void fillFulfilmentType(SourcingContext sourcingContext, List<SourcingUtils.Fulfilment> fulfilments) {
        FulfilmentChoice fulfilmentChoice = sourcingContext.getFulfilmentChoice();
        for (SourcingUtils.Fulfilment fulfilment : fulfilments) {
            String fulfilmentType = OrderUtils.getFulfilmentType(fulfilmentChoice, fulfilment.getLocation().getType());
            fulfilment.setType(fulfilmentType);
        }
    }

    public static void createFulfilments(Context context, SourcingContext sourcingContext, List<SourcingUtils.Fulfilment> fulfilments) {
        FulfilmentChoice fulfilmentChoice = sourcingContext.getFulfilmentChoice();
        for (SourcingUtils.Fulfilment fulfilment : fulfilments) {
            String toAddressId = fulfilmentChoice.getAddress().getId();
            CreateFulfilmentInput createFulfilmentInput = CreateFulfilmentInput.builder().fromAddress(AddressId.builder().id(fulfilment.getLocation().getPrimaryAddress().getId()).build()).toAddress(AddressId.builder().id(toAddressId).build()).type(fulfilment.getType()).items(OrderUtils.mapItemsToInput(fulfilment.getItems())).order(OrderId.builder().id(sourcingContext.getId()).build()).ref(UUID.randomUUID().toString()).deliveryType(sourcingContext.getFulfilmentChoice().getDeliveryType()).fulfilmentChoiceRef(sourcingContext.getFulfilmentChoice().getRef()).build();
            CreateFulfilmentMutation createFulfilment = CreateFulfilmentMutation.builder().input(createFulfilmentInput).build();
            context.action().mutation((Mutation)createFulfilment);
        }
    }

    public static String getFulfilmentType(FulfilmentChoice fulfilmentChoice, String locationType) {
        String fulfilmentType;
        switch (fulfilmentChoice.getType()) {
            case "CC": 
            case "HD": {
                fulfilmentType = fulfilmentChoice.getType() + "_" + FulfilmentUtils.getSuffixAsPerLocationType((String)locationType);
                break;
            }
            default: {
                throw new RubixException(CoreExceptionCode.ErrorCode.ERROR_CODE_400.getValue().intValue(), "{{fulfilmentType}} parameter to be set in the order workflow due to " + fulfilmentChoice.getType() + " order type");
            }
        }
        return fulfilmentType;
    }

    private static List<CreateFulfilmentItemWithFulfilmentInput> mapItemsToInput(List<Fulfilment.FulfilmentItem> items) {
        ArrayList<CreateFulfilmentItemWithFulfilmentInput> mappedItems = new ArrayList<CreateFulfilmentItemWithFulfilmentInput>();
        for (Fulfilment.FulfilmentItem item : items) {
            mappedItems.add(CreateFulfilmentItemWithFulfilmentInput.builder().ref(item.getOrderItem().getProduct().getRef()).orderItem(OrderItemId.builder().id(item.getOrderItem().getId()).build()).requestedQuantity(Optional.ofNullable(item.getRequestedQuantity()).orElse(0)).rejectedQuantity(Optional.ofNullable(item.getRejectedQuantity()).orElse(0)).build());
        }
        return mappedItems;
    }

    private OrderUtils() {
    }
}

