/*
 * Decompiled with CFR 0.152.
 */
package com.fluentcommerce.util.sourcing;

import com.apollographql.apollo.api.Query;
import com.fluentcommerce.graphql.sourcing.queries.location.GetFullLocationByRefQuery;
import com.fluentcommerce.graphql.sourcing.queries.location.GetFullLocationsByNetworkQuery;
import com.fluentcommerce.util.dynamic.JsonUtils;
import com.fluentcommerce.util.sourcing.context.SourcingContextUtils;
import com.fluentcommerce.util.sourcing.context.model.Address;
import com.fluentcommerce.util.sourcing.context.model.Location;
import com.fluentcommerce.util.sourcing.context.model.OpeningSchedule;
import com.fluentcommerce.util.sourcing.context.model.Retailer;
import com.fluentcommerce.util.units.DistanceMeasurementUnits;
import com.fluentretail.rubix.v2.context.Context;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class LocationUtils {
    private static final int CACHE_EXPIRY_MINUTES = 10;
    private static final int CACHE_MAX_SIZE = 100;
    private static final Cache<String, Optional<Location>> locationCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(100L).build();
    private static final Cache<String, List<Location>> networkCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(100L).build();

    public static void resetCacheForTest() {
        locationCache.invalidateAll();
        networkCache.invalidateAll();
    }

    public static List<Location> getLocationsInNetwork(Context context, String networkRef) {
        return (List)networkCache.get((Object)networkRef, () -> {
            GetFullLocationsByNetworkQuery.Data response = (GetFullLocationsByNetworkQuery.Data)context.api().query((Query)GetFullLocationsByNetworkQuery.builder().network(networkRef).build());
            ImmutableList.Builder builder = ImmutableList.builder();
            if (response.network() != null && response.network().locations() != null && response.network().locations().edges() != null) {
                response.network().locations().edges().stream().forEach(edge -> {
                    GetFullLocationsByNetworkQuery.Node loc = edge.node();
                    if (loc != null) {
                        builder.add((Object)LocationUtils.mapLocation(loc));
                    }
                });
            }
            return builder.build();
        });
    }

    public static List<Location> getLocationsInNetworks(Context context, List<String> networkRefs) {
        ImmutableList.Builder allLocations = ImmutableList.builder();
        for (String network : networkRefs) {
            List<Location> locations = LocationUtils.getLocationsInNetwork(context, network);
            allLocations.addAll(locations);
        }
        return allLocations.build();
    }

    public static Location getLocationByRef(Context context, String locationRef) {
        if (locationRef == null) {
            return null;
        }
        return ((Optional)locationCache.get((Object)locationRef, () -> Optional.of(locationRef).map(ref -> (GetFullLocationByRefQuery.Data)context.api().query((Query)GetFullLocationByRefQuery.builder().locationRef((String)ref).build())).map(GetFullLocationByRefQuery.Data::location).map(LocationUtils::mapLocation))).orElse(null);
    }

    public static double distanceInMetres(double lat1, double lon1, double lat2, double lon2) {
        return LocationUtils.distanceInKilometres(lat1, lon1, lat2, lon2) * 1000.0;
    }

    public static double distanceInKilometres(double lat1, double lon1, double lat2, double lon2) {
        int radius = 6371;
        return 6371.0 * LocationUtils.calculateAngularDistance(lat1, lon1, lat2, lon2);
    }

    public static double distanceInMiles(double lat1, double lon1, double lat2, double lon2) {
        int radius = 3959;
        return 3959.0 * LocationUtils.calculateAngularDistance(lat1, lon1, lat2, lon2);
    }

    public static double calculateDistance(double lat1, double lon1, double lat2, double lon2, DistanceMeasurementUnits unit) {
        switch (unit) {
            case MILES: {
                return LocationUtils.distanceInMiles(lat1, lon1, lat2, lon2);
            }
            case METRES: {
                return LocationUtils.distanceInMetres(lat1, lon1, lat2, lon2);
            }
            case KILOMETRES: {
                return LocationUtils.distanceInKilometres(lat1, lon1, lat2, lon2);
            }
        }
        throw new IllegalArgumentException("Unsupported distance unit: " + unit);
    }

    private static double calculateAngularDistance(double lat1, double lon1, double lat2, double lon2) {
        double latDistance = Math.toRadians(lat2 - lat1);
        double lonDistance = Math.toRadians(lon2 - lon1);
        double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        return 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
    }

    private static Location mapLocation(GetFullLocationByRefQuery.Location location) {
        if (location == null) {
            return null;
        }
        return Location.builder().id(location.id()).ref(location.ref()).createdOn((Date)location.createdOn()).updatedOn((Date)location.updatedOn()).type(location.type()).status(location.status()).attributes(SourcingContextUtils.mapAttributes(location.attributes())).name(location.name()).supportPhoneNumber(location.supportPhoneNumber()).defaultCarrier(location.defaultCarrier()).defaultCarrierName(location.defaultCarrierName()).primaryAddress((Address)JsonUtils.anyToPojo((Object)location.primaryAddress(), Address.class)).retailer((Retailer)JsonUtils.anyToPojo((Object)location.retailer(), Retailer.class)).networks(Optional.ofNullable(location.networks()).map(GetFullLocationByRefQuery.Networks::edges).map(edges -> edges.stream().map(edge -> Optional.ofNullable(edge).map(GetFullLocationByRefQuery.Edge::node).map(GetFullLocationByRefQuery.Node::ref).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList())).orElse(null)).openingSchedule((OpeningSchedule)JsonUtils.anyToPojo((Object)location.openingSchedule(), OpeningSchedule.class)).build();
    }

    private static Location mapLocation(GetFullLocationsByNetworkQuery.Node location) {
        if (location == null) {
            return null;
        }
        return Location.builder().id(location.id()).ref(location.ref()).createdOn((Date)location.createdOn()).updatedOn((Date)location.updatedOn()).type(location.type()).status(location.status()).attributes(SourcingContextUtils.mapAttributes(location.attributes())).name(location.name()).supportPhoneNumber(location.supportPhoneNumber()).defaultCarrier(location.defaultCarrier()).defaultCarrierName(location.defaultCarrierName()).primaryAddress((Address)JsonUtils.anyToPojo((Object)location.primaryAddress(), Address.class)).retailer((Retailer)JsonUtils.anyToPojo((Object)location.retailer(), Retailer.class)).networks(Optional.ofNullable(location.networks()).map(GetFullLocationsByNetworkQuery.Networks::edges).map(edges -> edges.stream().map(edge -> Optional.ofNullable(edge).map(GetFullLocationsByNetworkQuery.Edge1::node).map(GetFullLocationsByNetworkQuery.Node1::ref).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList())).orElse(null)).openingSchedule((OpeningSchedule)JsonUtils.anyToPojo((Object)location.openingSchedule(), OpeningSchedule.class)).build();
    }

    private LocationUtils() {
    }
}

