/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.profile;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * Represents Sourcing Strategy and Fallback Sourcing Strategy entities retrieved from GraphQL
 */
@Data
@Builder
@AllArgsConstructor
public class SourcingStrategy {

    private String ref;
    private Integer priority;
    private String status;
    private VirtualCatalogue virtualCatalogue;
    private Network network;
    private Integer maxSplit;
    private List<SourcingStrategyCondition> sourcingConditions;
    private List<SourcingStrategyCriterion> sourcingCriteria;

    /**
     * Represents Sourcing Condition configuration entity retrieved from GraphQL
     */
    @Data
    @Builder
    @AllArgsConstructor
    public static class SourcingStrategyCondition {
        private String name;
        private String type;
        private Object params;
    }

    /**
     * Represents Sourcing Criterion configuration entity retrieved from GraphQL
     */
    @Data
    @AllArgsConstructor
    public static class SourcingStrategyCriterion {
        private String name;
        private String type;
        private Object params;
    }

}
