/*
 * Copyright © 2024, 2025 Fluent Commerce - All Rights Reserved.
 */
package com.fluentcommerce.util.sourcing.profile;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * Represents a Sourcing Profile entity retrieved from GraphQL
 */
@Builder
@Data
@AllArgsConstructor
public class SourcingProfile {

    private String id;
    private String ref;
    private VirtualCatalogue defaultVirtualCatalogue;
    private Network defaultNetwork;
    private Integer defaultMaxSplit;

    private List<SourcingStrategy> sourcingStrategies;
    private List<SourcingStrategy> sourcingFallbackStrategies;

}
